/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryConfigurer;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.context.ApplicationContext;

class MeterRegistryPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<MeterBinder> meterBinders;
    private final ObjectProvider<MeterFilter> meterFilters;
    private final ObjectProvider<MeterRegistryCustomizer<?>> meterRegistryCustomizers;
    private final ObjectProvider<MetricsProperties> metricsProperties;
    private volatile MeterRegistryConfigurer configurer;
    private final ApplicationContext applicationContext;

    MeterRegistryPostProcessor(ObjectProvider<MeterBinder> meterBinders, ObjectProvider<MeterFilter> meterFilters, ObjectProvider<MeterRegistryCustomizer<?>> meterRegistryCustomizers, ObjectProvider<MetricsProperties> metricsProperties, ApplicationContext applicationContext) {
        this.meterBinders = meterBinders;
        this.meterFilters = meterFilters;
        this.meterRegistryCustomizers = meterRegistryCustomizers;
        this.metricsProperties = metricsProperties;
        this.applicationContext = applicationContext;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof MeterRegistry) {
            this.getConfigurer().configure((MeterRegistry)bean2);
        }
        return bean2;
    }

    private MeterRegistryConfigurer getConfigurer() {
        if (this.configurer == null) {
            boolean hasCompositeMeterRegistry = this.applicationContext.getBeanNamesForType(CompositeMeterRegistry.class, false, false).length != 0;
            this.configurer = new MeterRegistryConfigurer(this.meterRegistryCustomizers, this.meterFilters, this.meterBinders, ((MetricsProperties)this.metricsProperties.getObject()).isUseGlobalRegistry(), hasCompositeMeterRegistry);
        }
        return this.configurer;
    }
}

