/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.query;

import java.lang.reflect.Constructor;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.SpelCriteria;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Lazy;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class KeyValuePartTreeQuery
implements RepositoryQuery {
    private final Lazy<PartTree> partTree;
    private final QueryMethod queryMethod;
    private final KeyValueOperations keyValueOperations;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final QueryCreatorFactory<AbstractQueryCreator<KeyValueQuery<?>, ?>> queryCreatorFactory;

    public KeyValuePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        this(queryMethod, evaluationContextProvider, keyValueOperations, new ConstructorCachingQueryCreatorFactory(queryCreator));
    }

    public KeyValuePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, QueryCreatorFactory<AbstractQueryCreator<KeyValueQuery<?>, ?>> queryCreatorFactory) {
        Assert.notNull((Object)queryMethod, "Query method must not be null!");
        Assert.notNull((Object)evaluationContextProvider, "EvaluationContextprovider must not be null!");
        Assert.notNull((Object)keyValueOperations, "KeyValueOperations must not be null!");
        Assert.notNull(queryCreatorFactory, "QueryCreatorFactory type must not be null!");
        this.partTree = Lazy.of(() -> new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType()));
        this.queryMethod = queryMethod;
        this.keyValueOperations = keyValueOperations;
        this.evaluationContextProvider = evaluationContextProvider;
        this.queryCreatorFactory = queryCreatorFactory;
    }

    @Override
    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        KeyValueQuery<?> query = this.prepareQuery(parameters);
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection(accessor);
        return processor.processResult(this.doExecute(parameters, query));
    }

    @Nullable
    protected Object doExecute(Object[] parameters, KeyValueQuery<?> query) {
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Pageable page = (Pageable)parameters[this.queryMethod.getParameters().getPageableIndex()];
            query.setOffset(page.getOffset());
            query.setRows(page.getPageSize());
            Iterable<?> result = this.keyValueOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
            long count = this.queryMethod.isSliceQuery() ? 0L : this.keyValueOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
            return new PageImpl(IterableConverter.toList(result), page, count);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.keyValueOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (this.queryMethod.isQueryForEntity()) {
            Iterable<?> result = this.keyValueOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
            return result.iterator().hasNext() ? result.iterator().next() : null;
        }
        if (this.partTree.get().isExistsProjection()) {
            return this.keyValueOperations.exists(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        throw new UnsupportedOperationException("Query method not supported.");
    }

    protected KeyValueQuery<?> prepareQuery(Object[] parameters) {
        return this.prepareQuery(this.createQuery(new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters)), parameters);
    }

    protected KeyValueQuery<?> prepareQuery(KeyValueQuery<?> instance, Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        Object criteria = instance.getCriteria();
        if (criteria instanceof SpelCriteria || criteria instanceof SpelExpression) {
            SpelExpression spelExpression = this.getSpelExpression(criteria);
            EvaluationContext context = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), parameters);
            criteria = new SpelCriteria(spelExpression, context);
        }
        KeyValueQuery query = new KeyValueQuery(criteria);
        Pageable pageable = accessor.getPageable();
        Sort sort = accessor.getSort();
        query.setOffset(pageable.toOptional().map(Pageable::getOffset).orElse(-1L));
        if (pageable.isPaged()) {
            query.setRows(pageable.getPageSize());
        } else if (instance.getRows() >= 0) {
            query.setRows(instance.getRows());
        }
        query.setSort(sort.isUnsorted() ? instance.getSort() : sort);
        return query;
    }

    private SpelExpression getSpelExpression(Object criteria) {
        if (criteria instanceof SpelExpression) {
            return (SpelExpression)criteria;
        }
        if (criteria instanceof SpelCriteria) {
            return this.getSpelExpression(((SpelCriteria)criteria).getExpression());
        }
        throw new IllegalStateException(String.format("Cannot retrieve SpelExpression from %s", criteria));
    }

    public KeyValueQuery<?> createQuery(ParameterAccessor accessor) {
        PartTree tree = this.partTree.get();
        AbstractQueryCreator<KeyValueQuery<?>, ?> queryCreator = this.queryCreatorFactory.queryCreatorFor(tree, accessor);
        KeyValueQuery<?> query = queryCreator.createQuery();
        if (tree.isLimiting()) {
            query.setRows(tree.getMaxResults());
        }
        return query;
    }

    @Override
    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private static class ConstructorCachingQueryCreatorFactory
    implements QueryCreatorFactory<AbstractQueryCreator<KeyValueQuery<?>, ?>> {
        private final Class<?> type;
        @Nullable
        private final Constructor<? extends AbstractQueryCreator<?, ?>> constructor;

        ConstructorCachingQueryCreatorFactory(Class<? extends AbstractQueryCreator<?, ?>> type) {
            this.type = type;
            this.constructor = ClassUtils.getConstructorIfAvailable(type, PartTree.class, ParameterAccessor.class);
        }

        @Override
        public AbstractQueryCreator<KeyValueQuery<?>, ?> queryCreatorFor(PartTree partTree, ParameterAccessor accessor) {
            Assert.state(this.constructor != null, () -> String.format("No constructor (PartTree, ParameterAccessor) could be found on type %s!", this.type));
            return BeanUtils.instantiateClass(this.constructor, partTree, accessor);
        }
    }

    public static interface QueryCreatorFactory<T extends AbstractQueryCreator<?, ?>> {
        public T queryCreatorFor(PartTree var1, ParameterAccessor var2);
    }
}

