/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

class JedisClusterHashCommands
implements RedisHashCommands {
    private final JedisClusterConnection connection;

    JedisClusterHashCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)field, "Field must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().hset(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)field, "Field must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().hsetnx(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)field, "Field must not be null!");
        try {
            return this.connection.getCluster().hget(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)fields, "Fields must not be null!");
        try {
            return this.connection.getCluster().hmget(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(hashes, "Hashes must not be null!");
        try {
            this.connection.getCluster().hmset(key, hashes);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)field, "Field must not be null!");
        try {
            return this.connection.getCluster().hincrBy(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)field, "Field must not be null!");
        try {
            return this.connection.getCluster().hincrByFloat(key, field, delta);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public byte[] hRandField(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().hrandfield(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public Map.Entry<byte[], byte[]> hRandFieldWithValues(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            Map map = this.connection.getCluster().hrandfieldWithValues(key, 1L);
            return map.isEmpty() ? null : map.entrySet().iterator().next();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public List<byte[]> hRandField(byte[] key, long count) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().hrandfield(key, count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    @Nullable
    public List<Map.Entry<byte[], byte[]>> hRandFieldWithValues(byte[] key, long count) {
        try {
            Map map = this.connection.getCluster().hrandfieldWithValues(key, count);
            return Streamable.of(() -> map.entrySet().iterator()).toList();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)field, "Field must not be null!");
        try {
            return this.connection.getCluster().hexists(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)fields, "Fields must not be null!");
        try {
            return this.connection.getCluster().hdel(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().hlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().hkeys(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return new ArrayList<byte[]>(this.connection.getCluster().hvals(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        try {
            return this.connection.getCluster().hgetAll(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(final byte[] key, ScanOptions options) {
        Assert.notNull((Object)key, "Key must not be null!");
        return new ScanCursor<Map.Entry<byte[], byte[]>>(options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(long cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisClusterHashCommands.this.connection.getCluster().hscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Long.valueOf(result.getCursor()), result.getResult());
            }
        }.open();
    }

    @Override
    @Nullable
    public Long hStrLen(byte[] key, byte[] field) {
        Assert.notNull((Object)key, "Key must not be null");
        Assert.notNull((Object)field, "Field must not be null");
        return this.connection.getCluster().hstrlen(key, field);
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

