/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.args.SaveMode;

class JedisServerCommands
implements RedisServerCommands {
    private final JedisConnection connection;

    JedisServerCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public void bgReWriteAof() {
        this.connection.invoke().just(BinaryJedis::bgrewriteaof, MultiKeyPipelineBase::bgrewriteaof);
    }

    @Override
    public void bgSave() {
        this.connection.invokeStatus().just(BinaryJedis::bgsave, MultiKeyPipelineBase::bgsave);
    }

    @Override
    public Long lastSave() {
        return this.connection.invoke().just(BinaryJedis::lastsave, MultiKeyPipelineBase::lastsave);
    }

    @Override
    public void save() {
        this.connection.invokeStatus().just(BinaryJedis::save, MultiKeyPipelineBase::save);
    }

    @Override
    public Long dbSize() {
        return this.connection.invoke().just(BinaryJedis::dbSize, MultiKeyPipelineBase::dbSize);
    }

    @Override
    public void flushDb() {
        this.connection.invokeStatus().just(BinaryJedis::flushDB, MultiKeyPipelineBase::flushDB);
    }

    @Override
    public void flushDb(RedisServerCommands.FlushOption option) {
        this.connection.invokeStatus().just(BinaryJedis::flushDB, MultiKeyPipelineBase::flushDB, JedisConverters.toFlushMode(option));
    }

    @Override
    public void flushAll() {
        this.connection.invokeStatus().just(BinaryJedis::flushAll, MultiKeyPipelineBase::flushAll);
    }

    @Override
    public void flushAll(RedisServerCommands.FlushOption option) {
        this.connection.invokeStatus().just(BinaryJedis::flushAll, MultiKeyPipelineBase::flushAll, JedisConverters.toFlushMode(option));
    }

    @Override
    public Properties info() {
        return this.connection.invoke().from(BinaryJedis::info, MultiKeyPipelineBase::info).get(Converters::toProperties);
    }

    @Override
    public Properties info(String section) {
        Assert.notNull((Object)section, "Section must not be null!");
        return this.connection.invoke().from(BinaryJedis::info, MultiKeyPipelineBase::info, section).get(Converters::toProperties);
    }

    @Override
    public void shutdown() {
        this.connection.invokeStatus().just(BinaryJedis::shutdown, MultiKeyPipelineBase::shutdown);
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        SaveMode saveMode = option == RedisServerCommands.ShutdownOption.NOSAVE ? SaveMode.NOSAVE : SaveMode.SAVE;
        this.connection.getJedis().shutdown(saveMode);
    }

    @Override
    public Properties getConfig(String pattern) {
        Assert.notNull((Object)pattern, "Pattern must not be null!");
        return this.connection.invoke().from(Jedis::configGet, MultiKeyPipelineBase::configGet, pattern).get(Converters::toProperties);
    }

    @Override
    public void setConfig(String param, String value) {
        Assert.notNull((Object)param, "Parameter must not be null!");
        Assert.notNull((Object)value, "Value must not be null!");
        this.connection.invokeStatus().just(Jedis::configSet, MultiKeyPipelineBase::configSet, param, value);
    }

    @Override
    public void resetConfigStats() {
        this.connection.invokeStatus().just(BinaryJedis::configResetStat, MultiKeyPipelineBase::configResetStat);
    }

    @Override
    public void rewriteConfig() {
        this.connection.invokeStatus().just(BinaryJedis::configRewrite);
    }

    @Override
    public Long time(TimeUnit timeUnit) {
        Assert.notNull((Object)timeUnit, "TimeUnit must not be null.");
        return this.connection.invoke().from(BinaryJedis::time, MultiKeyPipelineBase::time).get(source -> JedisConverters.toTime(source, timeUnit));
    }

    @Override
    public void killClient(String host, int port) {
        Assert.hasText(host, "Host for 'CLIENT KILL' must not be 'null' or 'empty'.");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'CLIENT KILL' is not supported in transaction / pipline mode.");
        }
        this.connection.invokeStatus().just(it -> it.clientKill(String.format("%s:%s", host, port)));
    }

    @Override
    public void setClientName(byte[] name) {
        Assert.notNull((Object)name, "Name must not be null!");
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException("'CLIENT SETNAME' is not suppored in transacton / pipeline mode.");
        }
        this.connection.invokeStatus().just(it -> it.clientSetname(name));
    }

    @Override
    public String getClientName() {
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        return this.connection.invokeStatus().just(Jedis::clientGetname);
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'CLIENT LIST' is not supported in in pipeline / multi mode.");
        }
        return this.connection.invokeStatus().from(Jedis::clientList).get(JedisConverters::toListOfRedisClientInformation);
    }

    @Override
    public void slaveOf(String host, int port) {
        Assert.hasText(host, "Host must not be null for 'SLAVEOF' command.");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'SLAVEOF' cannot be called in pipline / transaction mode.");
        }
        this.connection.invokeStatus().just(it -> it.slaveof(host, port));
    }

    @Override
    public void slaveOfNoOne() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'SLAVEOF' cannot be called in pipline / transaction mode.");
        }
        this.connection.invokeStatus().just(BinaryJedis::slaveofNoOne);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option, long timeout) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)target, "Target node must not be null!");
        int timeoutToUse = timeout <= Integer.MAX_VALUE ? (int)timeout : Integer.MAX_VALUE;
        this.connection.invokeStatus().just(BinaryJedis::migrate, PipelineBase::migrate, target.getHost(), target.getPort(), key, dbIndex, timeoutToUse);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

