/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.ReactiveClusterSetCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveSetCommands;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveClusterSetCommands
extends LettuceReactiveSetCommands
implements ReactiveClusterSetCommands {
    LettuceReactiveClusterSetCommands(LettuceReactiveRedisConnection connection) {
        super(connection);
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SUnionCommand, Flux<ByteBuffer>>> sUnion(Publisher<ReactiveSetCommands.SUnionCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeys())) {
                return super.sUnion(Mono.just(command));
            }
            Flux result = Flux.merge(command.getKeys().stream().map(arg_0 -> ((RedisClusterReactiveCommands)cmd).smembers(arg_0)).collect(Collectors.toList())).distinct();
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveSetCommands.SUnionCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SUnionStoreCommand, Long>> sUnionStore(Publisher<ReactiveSetCommands.SUnionStoreCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Source keys must not be null!");
            Assert.notNull((Object)command.getKey(), "Destination key must not be null!");
            ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(command.getKeys());
            keys.add(command.getKey());
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
                return super.sUnionStore(Mono.just(command));
            }
            return this.sUnion(Mono.just(ReactiveSetCommands.SUnionCommand.keys(command.getKeys()))).next().flatMap(values -> {
                Mono<ReactiveRedisConnection.NumericResponse> result = ((Flux)values.getOutput()).collectList().flatMap(it -> {
                    Object[] members = it.toArray(new ByteBuffer[0]);
                    return cmd.sadd((Object)command.getKey(), members);
                });
                return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SUnionStoreCommand, Long>((ReactiveSetCommands.SUnionStoreCommand)command, (Long)value));
            });
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SInterCommand, Flux<ByteBuffer>>> sInter(Publisher<ReactiveSetCommands.SInterCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeys())) {
                return super.sInter(Mono.just(command));
            }
            Mono sourceSet = cmd.smembers((Object)command.getKeys().get(0)).distinct().collectList();
            ArrayList intersectingSets = new ArrayList();
            for (int i = 1; i < command.getKeys().size(); ++i) {
                intersectingSets.add(cmd.smembers((Object)command.getKeys().get(i)).distinct().collectList());
            }
            Flux<List> result = Flux.zip(sourceSet, Flux.merge(intersectingSets).collectList(), (source, intersectings) -> {
                for (List intersecting : intersectings) {
                    source.retainAll(intersecting);
                }
                return source;
            });
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveSetCommands.SInterCommand)command, result.concatMap(v -> Flux.fromStream(v.stream()))));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SInterStoreCommand, Long>> sInterStore(Publisher<ReactiveSetCommands.SInterStoreCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Source keys must not be null!");
            Assert.notNull((Object)command.getKey(), "Destination key must not be null!");
            ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(command.getKeys());
            keys.add(command.getKey());
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
                return super.sInterStore(Mono.just(command));
            }
            return this.sInter(Mono.just(ReactiveSetCommands.SInterCommand.keys(command.getKeys()))).next().flatMap(values -> {
                Mono<ReactiveRedisConnection.NumericResponse> result = ((Flux)values.getOutput()).collectList().flatMap(it -> {
                    Object[] members = it.toArray(new ByteBuffer[0]);
                    return cmd.sadd((Object)command.getKey(), members);
                });
                return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SInterStoreCommand, Long>((ReactiveSetCommands.SInterStoreCommand)command, (Long)value));
            });
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveSetCommands.SDiffCommand, Flux<ByteBuffer>>> sDiff(Publisher<ReactiveSetCommands.SDiffCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKeys())) {
                return super.sDiff(Mono.just(command));
            }
            Mono sourceSet = cmd.smembers((Object)command.getKeys().get(0)).distinct().collectList();
            ArrayList intersectingSets = new ArrayList();
            for (int i = 1; i < command.getKeys().size(); ++i) {
                intersectingSets.add(cmd.smembers((Object)command.getKeys().get(i)).distinct().collectList());
            }
            Flux<List> result = Flux.zip(sourceSet, Flux.merge(intersectingSets).collectList(), (source, intersectings) -> {
                for (List intersecting : intersectings) {
                    source.removeAll(intersecting);
                }
                return source;
            });
            return Mono.just(new ReactiveRedisConnection.CommandResponse((ReactiveSetCommands.SDiffCommand)command, result.concatMap(v -> Flux.fromStream(v.stream()))));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SDiffStoreCommand, Long>> sDiffStore(Publisher<ReactiveSetCommands.SDiffStoreCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull(command.getKeys(), "Source keys must not be null!");
            Assert.notNull((Object)command.getKey(), "Destination key must not be null!");
            ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>(command.getKeys());
            keys.add(command.getKey());
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
                return super.sDiffStore(Mono.just(command));
            }
            return this.sDiff(Mono.just(ReactiveSetCommands.SDiffCommand.keys(command.getKeys()))).next().flatMap(values -> {
                Mono<ReactiveRedisConnection.NumericResponse> result = ((Flux)values.getOutput()).collectList().flatMap(it -> {
                    Object[] members = it.toArray(new ByteBuffer[0]);
                    return cmd.sadd((Object)command.getKey(), members);
                });
                return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveSetCommands.SDiffStoreCommand, Long>((ReactiveSetCommands.SDiffStoreCommand)command, (Long)value));
            });
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SMoveCommand>> sMove(Publisher<ReactiveSetCommands.SMoveCommand> commands) {
        return this.getConnection().execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Source key must not be null!");
            Assert.notNull((Object)command.getDestination(), "Destination key must not be null!");
            if (ClusterSlotHashUtil.isSameSlotForAllKeys(command.getKey(), command.getDestination())) {
                return super.sMove(Mono.just(command));
            }
            Mono result = cmd.exists((Object[])new ByteBuffer[]{command.getKey()}).flatMap(nrKeys -> nrKeys == 0L ? Mono.empty() : cmd.sismember((Object)command.getKey(), (Object)command.getValue())).flatMap(exists -> {
                if (!exists.booleanValue()) {
                    return Mono.just(Boolean.FALSE);
                }
                return cmd.sismember((Object)command.getDestination(), (Object)command.getValue()).flatMap(existsInTarget -> {
                    Mono<Boolean> tmp = cmd.srem((Object)command.getKey(), (Object[])new ByteBuffer[]{command.getValue()}).map(nrRemoved -> nrRemoved > 0L);
                    if (!existsInTarget.booleanValue()) {
                        return tmp.flatMap(removed -> cmd.sadd((Object)command.getDestination(), (Object[])new ByteBuffer[]{command.getValue()}).map(Converters::toBoolean));
                    }
                    return tmp;
                });
            });
            return result.defaultIfEmpty(Boolean.FALSE).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveSetCommands.SMoveCommand>((ReactiveSetCommands.SMoveCommand)command, (Boolean)value));
        }));
    }
}

