/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.Range;
import io.lettuce.core.codec.StringCodec;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class RangeConverter {
    RangeConverter() {
    }

    static <T> Range<T> toRange(org.springframework.data.domain.Range<?> range) {
        return RangeConverter.toRange(range, arg_0 -> ((StringCodec)StringCodec.UTF8).encodeValue(arg_0));
    }

    static <T> Range<T> toRangeWithDefault(org.springframework.data.domain.Range<?> range, @Nullable T lowerDefault, @Nullable T upperDefault) {
        return RangeConverter.toRangeWithDefault(range, lowerDefault, upperDefault, arg_0 -> ((StringCodec)StringCodec.UTF8).encodeValue(arg_0));
    }

    static <T> Range<T> toRange(org.springframework.data.domain.Range<?> range, Function<String, ? extends Object> stringEncoder) {
        return RangeConverter.toRangeWithDefault(range, null, null, stringEncoder);
    }

    static <T> Range<T> toRangeWithDefault(org.springframework.data.domain.Range<?> range, @Nullable T lowerDefault, @Nullable T upperDefault, Function<String, ? extends Object> stringEncoder) {
        return Range.from(RangeConverter.lowerBoundArgOf(range, lowerDefault, stringEncoder), RangeConverter.upperBoundArgOf(range, upperDefault, stringEncoder));
    }

    private static <T> Range.Boundary<T> lowerBoundArgOf(org.springframework.data.domain.Range<?> range, @Nullable T lowerDefault, Function<String, ? extends Object> stringEncoder) {
        return RangeConverter.rangeToBoundArgumentConverter(false, stringEncoder).apply(range, lowerDefault);
    }

    private static <T> Range.Boundary<T> upperBoundArgOf(org.springframework.data.domain.Range<?> range, @Nullable T upperDefault, Function<String, ? extends Object> stringEncoder) {
        return RangeConverter.rangeToBoundArgumentConverter(true, stringEncoder).apply(range, upperDefault);
    }

    private static BiFunction<org.springframework.data.domain.Range, Object, Range.Boundary<?>> rangeToBoundArgumentConverter(boolean upper, Function<String, ? extends Object> stringEncoder) {
        return (source, defaultValue) -> {
            Object value;
            Boolean inclusive = upper ? source.getUpperBound().isInclusive() : source.getLowerBound().isInclusive();
            Object object = value = upper ? source.getUpperBound().getValue().orElse(defaultValue) : source.getLowerBound().getValue().orElse(defaultValue);
            if (value instanceof Number) {
                return inclusive != false ? Range.Boundary.including((Object)((Number)value)) : Range.Boundary.excluding((Object)((Number)value));
            }
            if (value instanceof String) {
                if (!StringUtils.hasText((String)value) || ObjectUtils.nullSafeEquals(value, "+") || ObjectUtils.nullSafeEquals(value, "-")) {
                    return Range.Boundary.unbounded();
                }
                Object encoded = stringEncoder.apply((String)value);
                return inclusive != false ? Range.Boundary.including(encoded) : Range.Boundary.excluding(encoded);
            }
            if (value == null) {
                return Range.Boundary.unbounded();
            }
            return inclusive != false ? Range.Boundary.including((Object)((ByteBuffer)value)) : Range.Boundary.excluding((Object)((ByteBuffer)value));
        };
    }
}

