/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.mapping;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.context.KeyValueMappingContext;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.TimeToLiveAccessor;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.convert.MappingConfiguration;
import org.springframework.data.redis.core.convert.RedisCustomConversions;
import org.springframework.data.redis.core.index.IndexConfiguration;
import org.springframework.data.redis.core.mapping.BasicRedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.core.mapping.RedisPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class RedisMappingContext
extends KeyValueMappingContext<RedisPersistentEntity<?>, RedisPersistentProperty> {
    private static final SimpleTypeHolder SIMPLE_TYPE_HOLDER = new RedisCustomConversions().getSimpleTypeHolder();
    private final MappingConfiguration mappingConfiguration;
    private final TimeToLiveAccessor timeToLiveAccessor;
    @Nullable
    private KeySpaceResolver fallbackKeySpaceResolver;

    public RedisMappingContext() {
        this(new MappingConfiguration(new IndexConfiguration(), new KeyspaceConfiguration()));
    }

    public RedisMappingContext(@Nullable MappingConfiguration mappingConfiguration) {
        this.mappingConfiguration = mappingConfiguration != null ? mappingConfiguration : new MappingConfiguration(new IndexConfiguration(), new KeyspaceConfiguration());
        this.setFallbackKeySpaceResolver(new ConfigAwareKeySpaceResolver(this.mappingConfiguration.getKeyspaceConfiguration()));
        this.timeToLiveAccessor = new ConfigAwareTimeToLiveAccessor(this.mappingConfiguration.getKeyspaceConfiguration(), this);
        this.setSimpleTypeHolder(SIMPLE_TYPE_HOLDER);
    }

    @Override
    public void setFallbackKeySpaceResolver(@Nullable KeySpaceResolver fallbackKeySpaceResolver) {
        this.fallbackKeySpaceResolver = fallbackKeySpaceResolver;
    }

    @Override
    protected <T> RedisPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new BasicRedisPersistentEntity<T>(typeInformation, this.fallbackKeySpaceResolver, this.timeToLiveAccessor);
    }

    @Override
    protected RedisPersistentProperty createPersistentProperty(Property property, RedisPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new RedisPersistentProperty(property, (PersistentEntity<?, RedisPersistentProperty>)owner, simpleTypeHolder);
    }

    public MappingConfiguration getMappingConfiguration() {
        return this.mappingConfiguration;
    }

    static class ConfigAwareTimeToLiveAccessor
    implements TimeToLiveAccessor {
        private final Map<Class<?>, Long> defaultTimeouts;
        private final Map<Class<?>, PersistentProperty<?>> timeoutProperties;
        private final Map<Class<?>, Method> timeoutMethods;
        private final KeyspaceConfiguration keyspaceConfig;
        private final RedisMappingContext mappingContext;

        ConfigAwareTimeToLiveAccessor(KeyspaceConfiguration keyspaceConfig, RedisMappingContext mappingContext) {
            Assert.notNull((Object)keyspaceConfig, "KeyspaceConfiguration must not be null!");
            Assert.notNull((Object)mappingContext, "MappingContext must not be null!");
            this.defaultTimeouts = new HashMap();
            this.timeoutProperties = new HashMap();
            this.timeoutMethods = new HashMap();
            this.keyspaceConfig = keyspaceConfig;
            this.mappingContext = mappingContext;
        }

        @Override
        public Long getTimeToLive(Object source) {
            Assert.notNull(source, "Source must not be null!");
            Class<?> type = source instanceof Class ? (Class<?>)source : (source instanceof PartialUpdate ? ((PartialUpdate)source).getTarget() : source.getClass());
            Long defaultTimeout = this.resolveDefaultTimeOut(type);
            TimeUnit unit = TimeUnit.SECONDS;
            PersistentProperty<?> ttlProperty = this.resolveTtlProperty(type);
            if (ttlProperty != null && ttlProperty.isAnnotationPresent(TimeToLive.class)) {
                unit = ttlProperty.getRequiredAnnotation(TimeToLive.class).unit();
            }
            if (source instanceof PartialUpdate) {
                PartialUpdate update = (PartialUpdate)source;
                if (ttlProperty != null && !update.getPropertyUpdates().isEmpty()) {
                    for (PartialUpdate.PropertyUpdate pUpdate : update.getPropertyUpdates()) {
                        if (!PartialUpdate.UpdateCommand.SET.equals((Object)pUpdate.getCmd()) || !ttlProperty.getName().equals(pUpdate.getPropertyPath())) continue;
                        return TimeUnit.SECONDS.convert(NumberUtils.convertNumberToTargetClass((Number)pUpdate.getValue(), Long.class), unit);
                    }
                }
            } else if (ttlProperty != null) {
                RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
                Object ttlPropertyValue = entity.getPropertyAccessor(source).getProperty(ttlProperty);
                if (ttlPropertyValue != null) {
                    return TimeUnit.SECONDS.convert(((Number)ttlPropertyValue).longValue(), unit);
                }
            } else {
                Method timeoutMethod = this.resolveTimeMethod(type);
                if (timeoutMethod != null) {
                    if (!timeoutMethod.isAccessible()) {
                        ReflectionUtils.makeAccessible(timeoutMethod);
                    }
                    TimeToLive ttl = AnnotationUtils.findAnnotation(timeoutMethod, TimeToLive.class);
                    try {
                        Number timeout = (Number)timeoutMethod.invoke(source, new Object[0]);
                        if (timeout != null && ttl != null) {
                            return TimeUnit.SECONDS.convert(timeout.longValue(), ttl.unit());
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Not allowed to access method '" + timeoutMethod.getName() + "': " + e.getMessage(), e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException("Cannot invoke method '" + timeoutMethod.getName() + " without arguments': " + e.getMessage(), e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException("Cannot access method '" + timeoutMethod.getName() + "': " + e.getMessage(), e);
                    }
                }
            }
            return defaultTimeout;
        }

        @Override
        public boolean isExpiringEntity(Class<?> type) {
            Long defaultTimeOut = this.resolveDefaultTimeOut(type);
            if (defaultTimeOut != null && defaultTimeOut > 0L) {
                return true;
            }
            if (this.resolveTtlProperty(type) != null) {
                return true;
            }
            return this.resolveTimeMethod(type) != null;
        }

        @Nullable
        private Long resolveDefaultTimeOut(Class<?> type) {
            RedisHash hash;
            if (this.defaultTimeouts.containsKey(type)) {
                return this.defaultTimeouts.get(type);
            }
            Long defaultTimeout = null;
            if (this.keyspaceConfig.hasSettingsFor(type)) {
                defaultTimeout = this.keyspaceConfig.getKeyspaceSettings(type).getTimeToLive();
            }
            if ((hash = ((RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type)).findAnnotation(RedisHash.class)) != null && hash.timeToLive() > 0L) {
                defaultTimeout = hash.timeToLive();
            }
            this.defaultTimeouts.put(type, defaultTimeout);
            return defaultTimeout;
        }

        @Nullable
        private PersistentProperty<?> resolveTtlProperty(Class<?> type) {
            KeyspaceConfiguration.KeyspaceSettings settings;
            if (this.timeoutProperties.containsKey(type)) {
                return this.timeoutProperties.get(type);
            }
            RedisPersistentEntity entity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(type);
            Object ttlProperty = entity.getPersistentProperty(TimeToLive.class);
            if (ttlProperty != null) {
                this.timeoutProperties.put(type, (PersistentProperty<?>)ttlProperty);
                return ttlProperty;
            }
            if (this.keyspaceConfig.hasSettingsFor(type) && StringUtils.hasText((settings = this.keyspaceConfig.getKeyspaceSettings(type)).getTimeToLivePropertyName()) && (ttlProperty = entity.getPersistentProperty(settings.getTimeToLivePropertyName())) != null) {
                this.timeoutProperties.put(type, (PersistentProperty<?>)ttlProperty);
                return ttlProperty;
            }
            this.timeoutProperties.put(type, null);
            return null;
        }

        @Nullable
        private Method resolveTimeMethod(Class<?> type) {
            if (this.timeoutMethods.containsKey(type)) {
                return this.timeoutMethods.get(type);
            }
            this.timeoutMethods.put(type, null);
            ReflectionUtils.doWithMethods(type, method -> this.timeoutMethods.put(type, method), method -> ClassUtils.isAssignable(Number.class, method.getReturnType()) && AnnotationUtils.findAnnotation(method, TimeToLive.class) != null);
            return this.timeoutMethods.get(type);
        }
    }

    static enum ClassNameKeySpaceResolver implements KeySpaceResolver
    {
        INSTANCE;


        @Override
        public String resolveKeySpace(Class<?> type) {
            Assert.notNull(type, "Type must not be null!");
            return ClassUtils.getUserClass(type).getName();
        }
    }

    static class ConfigAwareKeySpaceResolver
    implements KeySpaceResolver {
        private final KeyspaceConfiguration keyspaceConfig;

        public ConfigAwareKeySpaceResolver(KeyspaceConfiguration keyspaceConfig) {
            this.keyspaceConfig = keyspaceConfig;
        }

        @Override
        public String resolveKeySpace(Class<?> type) {
            String value;
            Assert.notNull(type, "Type must not be null!");
            if (this.keyspaceConfig.hasSettingsFor(type) && StringUtils.hasText(value = this.keyspaceConfig.getKeyspaceSettings(type).getKeyspace())) {
                return value;
            }
            return ClassNameKeySpaceResolver.INSTANCE.resolveKeySpace(type);
        }
    }
}

