/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.hash.HashObjectReader;
import org.springframework.util.Assert;

public class BeanUtilsHashMapper<T>
implements HashMapper<T, String, String>,
HashObjectReader<String, String> {
    private final Class<T> type;

    public BeanUtilsHashMapper(Class<T> type) {
        this.type = type;
    }

    @Override
    public T fromHash(Map<String, String> hash) {
        return this.fromHash((Class<R>)this.type, hash);
    }

    @Override
    public <R> R fromHash(Class<R> type, Map<String, String> hash) {
        Assert.notNull(type, "Type must not be null");
        Assert.notNull(hash, "Hash must not be null");
        R instance = org.springframework.beans.BeanUtils.instantiateClass(type);
        try {
            BeanUtils.populate(instance, hash);
            return instance;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Map<String, String> toHash(T object) {
        try {
            Map map = BeanUtils.describe(object);
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot describe object " + object, ex);
        }
    }
}

