/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.spring.api.filter;

import cn.com.pg.paas.monitor.spring.common.properties.MonitorProperties;
import cn.com.pg.paas.monitor.spring.eventhub.api.ApiSendService;
import cn.com.pg.paas.monitor.spring.model.ApiMetricDTO;
import cn.com.pg.paas.monitor.spring.model.ServerInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.time.Instant;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@WebFilter(filterName="PaaSMonitorApiRequestFilter", urlPatterns={"/*"}, asyncSupported=true, dispatcherTypes={DispatcherType.REQUEST, DispatcherType.FORWARD})
public class ApiRequestFilter
extends OncePerRequestFilter
implements Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiRequestFilter.class);
    public static final String USER_AGENT = "user-agent";
    public static final String X_FORWARDED_FOR = "x-forwarded-for";
    private ApiSendService apiSendService;
    private ServerInfo serverInfo;
    private MonitorProperties monitorProperties;
    private boolean shouldNotFilter = false;

    public ApiRequestFilter() {
        log.info("init paas monitor api request filter");
    }

    protected void initFilterBean() throws ServletException {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (webApplicationContext.containsBean("paaMonitorApiSendService") && webApplicationContext.containsBean("paasMonitorProperties")) {
            this.apiSendService = (ApiSendService)webApplicationContext.getBean(ApiSendService.class);
            this.monitorProperties = (MonitorProperties)webApplicationContext.getBean(MonitorProperties.class);
            this.initServerInfo();
        } else {
            log.warn("can not autowire paas monitor bean, paas monitor is disabled");
            this.shouldNotFilter = true;
        }
    }

    private void initServerInfo() {
        this.serverInfo = new ServerInfo();
        this.serverInfo.setPodName(super.getEnvironment().getProperty("HOSTNAME", "UNKOWN"));
        this.serverInfo.setPlatform(super.getEnvironment().getProperty("platform", "UNKOWN"));
        this.serverInfo.setIpAddress(InetAddress.getLocalHost().getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        log.info("ApiRequestFilter :[{}] {}", (Object)request.getMethod(), (Object)request.getRequestURL().toString());
        long startTime = Instant.now().toEpochMilli();
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.collectRequestInfo(startTime, request, response);
        }
    }

    private void collectRequestInfo(long startTime, HttpServletRequest request, HttpServletResponse response) {
        long endTime = Instant.now().toEpochMilli();
        long responseTime = endTime - startTime;
        ApiMetricDTO apiMetricDTO = new ApiMetricDTO();
        apiMetricDTO.setApiName(request.getRequestURI());
        apiMetricDTO.setApiNameWithMethod(request.getMethod().toUpperCase() + " " + request.getRequestURI());
        apiMetricDTO.setAppName(this.monitorProperties.getApplicationName());
        apiMetricDTO.setCallTime(startTime);
        apiMetricDTO.setResponseTime(responseTime);
        apiMetricDTO.setHost(this.serverInfo.getIpAddress());
        apiMetricDTO.setPodName(this.serverInfo.getPodName());
        apiMetricDTO.setPlatform(this.serverInfo.getPlatform());
        apiMetricDTO.setHttpMethod(request.getMethod().toUpperCase());
        apiMetricDTO.setHttpStatusCode(response.getStatus());
        apiMetricDTO.setQueryString(request.getQueryString());
        apiMetricDTO.setUserAgent(request.getHeader(USER_AGENT));
        apiMetricDTO.setXff(request.getHeader(X_FORWARDED_FOR));
        apiMetricDTO.setTraceId(TraceContext.traceId());
        log.debug("apiMetric:{}", (Object)apiMetricDTO);
        this.apiSendService.sendApi(apiMetricDTO);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return this.shouldNotFilter || !this.monitorProperties.getApi().isEnabled();
    }
}

