/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.spring.api.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.Log4j2Metrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.ClassUtils;

@WebServlet(name="PaaMonitorPrmetheusServlet", urlPatterns={"/prometheus"})
public class MicrometerPrometheusServlet
extends HttpServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicrometerPrometheusServlet.class);
    private static final String LOGBACK_FILTER_CLASSNAME = "ch.qos.logback.classic.turbo.TurboFilter";
    private static final String LOG4J2_FILTER_CLASSNAME = "org.apache.logging.log4j.core.Filter";
    PrometheusMeterRegistry prometheusRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);

    public MicrometerPrometheusServlet() {
        new ClassLoaderMetrics().bindTo((MeterRegistry)this.prometheusRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)this.prometheusRegistry);
        new JvmGcMetrics().bindTo((MeterRegistry)this.prometheusRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)this.prometheusRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)this.prometheusRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)this.prometheusRegistry);
        new UptimeMetrics().bindTo((MeterRegistry)this.prometheusRegistry);
        if (ClassUtils.isPresent((String)LOGBACK_FILTER_CLASSNAME, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())) {
            new LogbackMetrics().bindTo((MeterRegistry)this.prometheusRegistry);
        }
        if (ClassUtils.isPresent((String)LOG4J2_FILTER_CLASSNAME, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())) {
            new Log4j2Metrics().bindTo((MeterRegistry)this.prometheusRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.debug("request paas monitor prometheus servlet");
        resp.setCharacterEncoding("UTF-8");
        resp.setHeader("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
        resp.setStatus(HttpStatus.OK.value());
        PrintWriter writer = resp.getWriter();
        try {
            writer.print(this.prometheusRegistry.scrape());
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                writer.close();
            }
        }
    }
}

