/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.spring.common.config;

import cn.com.pg.paas.monitor.spring.common.config.EnableApiCondition;
import cn.com.pg.paas.monitor.spring.common.config.EnableKpiCondition;
import cn.com.pg.paas.monitor.spring.common.properties.MonitorProperties;
import cn.com.pg.paas.monitor.spring.eventhub.api.ApiSendService;
import cn.com.pg.paas.monitor.spring.eventhub.kpi.KpiSendService;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class MonitorConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitorConfiguration.class);

    @Bean
    public static MonitorProperties paasMonitorProperties(Environment environment) {
        log.debug("init monitor properties");
        return new MonitorProperties(environment);
    }

    @Bean
    @Conditional(value={EnableApiCondition.class})
    public ApiSendService paaMonitorApiSendService() {
        return new ApiSendService();
    }

    @Bean
    public KpiSendService getKpiSendService() {
        return new KpiSendService();
    }

    @Bean(name={"apiEventHubClient"})
    @Conditional(value={EnableApiCondition.class})
    public static EventHubProducerAsyncClient getApiEventHubClient(MonitorProperties monitorProperties) {
        log.debug("init api EventHubClient");
        return MonitorConfiguration.createEventHubClient(monitorProperties.getApi().getConnectionString());
    }

    @Bean(name={"kpiEventHubClient"})
    @Conditional(value={EnableKpiCondition.class})
    public static EventHubProducerAsyncClient getKpiEventHubClient(MonitorProperties monitorProperties) {
        log.debug("init kpi EventHubClient");
        return MonitorConfiguration.createEventHubClient(monitorProperties.getKpi().getConnectionString());
    }

    private static EventHubProducerAsyncClient createEventHubClient(String connectionString) {
        return new EventHubClientBuilder().connectionString(connectionString).buildAsyncProducerClient();
    }
}

