/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.spring.common.properties;

import cn.com.pg.paas.monitor.spring.common.exception.MonitorException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public class MonitorProperties {
    private static final String CONFIG_APPLICATION_NAME = "paas.monitor.application.name";
    private static final String CONFIG_EVENTHUB_API_ENABLED = "paas.monitor.eventhub.api.enabled";
    private static final boolean CONFIG_EVENTHUB_API_ENABLED_DEFAULT_VALUE = true;
    private static final String CONFIG_EVENTHUB_API_CONNECTION_STRING = "paas.monitor.eventhub.api.connectionString";
    private static final String CONFIG_EVENTHUB_KPI_ENABLED = "paas.monitor.eventhub.kpi.enabled";
    private static final boolean CONFIG_EVENTHUB_KPI_ENABLED_DEFAULT_VALUE = true;
    private static final String CONFIG_EVENTHUB_KPI_CONNECTION_STRING = "paas.monitor.eventhub.kpi.connectionString";
    private static final String CONFIG_NOT_EMPTY_DOC = " can not be empty ";
    private Environment environment;
    private String applicationName;
    private EventHubConfigProperties api = new EventHubConfigProperties();
    private EventHubConfigProperties kpi = new EventHubConfigProperties();

    public MonitorProperties(Environment environment) {
        this.environment = environment;
        String appName = this.environment.getProperty(CONFIG_APPLICATION_NAME);
        if (StringUtils.isBlank((CharSequence)appName)) {
            throw new MonitorException("paas.monitor.application.name can not be empty ");
        }
        this.applicationName = appName;
        boolean isApiEnabled = (Boolean)this.environment.getProperty(CONFIG_EVENTHUB_API_ENABLED, Boolean.class, (Object)true);
        this.getApi().setEnabled(isApiEnabled);
        if (isApiEnabled) {
            String apiConnectionString = this.environment.getProperty(CONFIG_EVENTHUB_API_CONNECTION_STRING);
            if (StringUtils.isBlank((CharSequence)apiConnectionString)) {
                throw new MonitorException("paas.monitor.eventhub.api.connectionString can not be empty ");
            }
            this.getApi().setConnectionString(apiConnectionString);
        }
        boolean isKpiEnabled = (Boolean)this.environment.getProperty(CONFIG_EVENTHUB_KPI_ENABLED, Boolean.class, (Object)true);
        this.getKpi().setEnabled(isKpiEnabled);
        if (isKpiEnabled) {
            String kpiConnectionString = this.environment.getProperty(CONFIG_EVENTHUB_KPI_CONNECTION_STRING);
            if (StringUtils.isBlank((CharSequence)kpiConnectionString)) {
                throw new MonitorException("paas.monitor.eventhub.kpi.connectionString can not be empty ");
            }
            this.getKpi().setConnectionString(kpiConnectionString);
        }
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public EventHubConfigProperties getApi() {
        return this.api;
    }

    @Generated
    public EventHubConfigProperties getKpi() {
        return this.kpi;
    }

    @Generated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setApi(EventHubConfigProperties api) {
        this.api = api;
    }

    @Generated
    public void setKpi(EventHubConfigProperties kpi) {
        this.kpi = kpi;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorProperties)) {
            return false;
        }
        MonitorProperties other = (MonitorProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        EventHubConfigProperties this$api = this.getApi();
        EventHubConfigProperties other$api = other.getApi();
        if (this$api == null ? other$api != null : !((Object)this$api).equals(other$api)) {
            return false;
        }
        EventHubConfigProperties this$kpi = this.getKpi();
        EventHubConfigProperties other$kpi = other.getKpi();
        return !(this$kpi == null ? other$kpi != null : !((Object)this$kpi).equals(other$kpi));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MonitorProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        EventHubConfigProperties $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : ((Object)$api).hashCode());
        EventHubConfigProperties $kpi = this.getKpi();
        result = result * 59 + ($kpi == null ? 43 : ((Object)$kpi).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MonitorProperties(environment=" + this.getEnvironment() + ", applicationName=" + this.getApplicationName() + ", api=" + this.getApi() + ", kpi=" + this.getKpi() + ")";
    }

    public static class EventHubConfigProperties {
        private boolean enabled = true;
        private String connectionString;

        @Generated
        public EventHubConfigProperties() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getConnectionString() {
            return this.connectionString;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setConnectionString(String connectionString) {
            this.connectionString = connectionString;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventHubConfigProperties)) {
                return false;
            }
            EventHubConfigProperties other = (EventHubConfigProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$connectionString = this.getConnectionString();
            String other$connectionString = other.getConnectionString();
            return !(this$connectionString == null ? other$connectionString != null : !this$connectionString.equals(other$connectionString));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EventHubConfigProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $connectionString = this.getConnectionString();
            result = result * 59 + ($connectionString == null ? 43 : $connectionString.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MonitorProperties.EventHubConfigProperties(enabled=" + this.isEnabled() + ", connectionString=" + this.getConnectionString() + ")";
        }
    }
}

