/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.spring.eventhub;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.Charset;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventHubSendService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEventHubSendService.class);
    final Gson gson = new GsonBuilder().create();

    protected void send(Object payloadObject) {
        String json = this.gson.toJson(payloadObject);
        log.info("send event hub kpi payload:{}", (Object)json);
        this.send(json.getBytes(Charset.defaultCharset()));
    }

    protected void send(Map<String, Object> payloadMap) {
        String json = this.gson.toJson(payloadMap);
        log.info("send event hub kpi payload:{}", (Object)json);
        this.send(json.getBytes(Charset.defaultCharset()));
    }

    private void send(byte[] payloadBytes) {
        this.send(new EventData(payloadBytes));
    }

    private void send(EventData eventData) {
        EventHubProducerAsyncClient eventHubClient = this.getEventHubClient();
        eventHubClient.createBatch().flatMap(batch -> {
            batch.tryAdd(eventData);
            return eventHubClient.send(batch);
        }).subscribe(unused -> {}, error -> log.error("send error"), () -> log.debug("send complete"));
    }

    protected abstract EventHubProducerAsyncClient getEventHubClient();
}

