/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.spring.eventhub.kpi;

import cn.com.pg.paas.monitor.spring.common.properties.MonitorProperties;
import cn.com.pg.paas.monitor.spring.eventhub.AbstractEventHubSendService;
import cn.com.pg.paas.monitor.spring.model.OrderMetric;
import cn.com.pg.paas.monitor.spring.model.ServiceInfo;
import cn.com.pg.paas.monitor.spring.model.TaskInfo;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class KpiSendService
extends AbstractEventHubSendService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KpiSendService.class);
    @Autowired(required=false)
    @Qualifier(value="kpiEventHubClient")
    EventHubProducerAsyncClient kpiEventHubClient;
    @Autowired
    MonitorProperties monitorProperties;

    public void sendKpi(Map<String, Object> payloadMap) {
        if (this.kpiEventHubClient != null) {
            payloadMap.put("app_name", this.monitorProperties.getApplicationName());
            super.send(payloadMap);
        } else {
            log.warn("paas monitor send kpi is disabled");
        }
    }

    public void sendKpi(OrderMetric orderMetric) {
        this.checkParam(orderMetric);
        if (this.kpiEventHubClient != null) {
            super.send(orderMetric);
        } else {
            log.warn("paas monitor send kpi is disabled");
        }
    }

    private void checkParam(OrderMetric orderMetric) {
        ServiceInfo serviceInfo = orderMetric.getServiceInfo();
        Assert.notNull((Object)serviceInfo, (String)"order metric service info is required");
        Assert.hasText((String)serviceInfo.getServiceName(), (String)"order metric service name is required");
        Assert.notNull((Object)((Object)serviceInfo.getChannelName()), (String)"order metric channel name is required");
        Assert.notNull((Object)serviceInfo.getTenantCode(), (String)"order metric tenant code is required");
        TaskInfo taskInfo = orderMetric.getTaskInfo();
        Assert.notNull((Object)taskInfo, (String)"order metric task  info is required");
        Assert.notNull((Object)taskInfo.getTaskId(), (String)"order metric task id info is required");
        Assert.notNull((Object)taskInfo.getTaskName(), (String)"order metric task name info is required");
        Assert.notNull((Object)taskInfo.getTaskOrder(), (String)"order metric task order info is required");
        Assert.notNull((Object)taskInfo.getSuccess(), (String)"order metric task status result is required");
    }

    @Override
    protected EventHubProducerAsyncClient getEventHubClient() {
        return this.kpiEventHubClient;
    }
}

