/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.spring.logging.log4j;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;

public class TraceIdJsonLayout
extends Layout {
    public static final String SYSTEM_ENV_PROP_KEY = "logging.layout";
    public static final String SYSTEM_ENV_PROP_VALUE = "JsonLayout";
    public static final FastDateFormat DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS", (TimeZone)TimeZone.getTimeZone("GMT+8"));
    private final Gson gson = new GsonBuilder().create();
    private LinkedHashMap<String, Object> logEventMap = new LinkedHashMap();

    public TraceIdJsonLayout() {
        System.setProperty(SYSTEM_ENV_PROP_KEY, SYSTEM_ENV_PROP_VALUE);
    }

    public String format(LoggingEvent event) {
        Throwable throwable;
        this.logEventMap.clear();
        this.addEventData("timestamp", TraceIdJsonLayout.dateFormat(event.getTimeStamp()));
        this.addEventData("level", event.getLevel().toString());
        this.addEventData("thread", event.getThreadName());
        this.addEventData("logger", event.getLoggerName());
        this.addEventData("message", event.getRenderedMessage());
        if (event.getThrowableInformation() != null && (throwable = event.getThrowableInformation().getThrowable()) != null) {
            this.addEventData("exception", ExceptionUtils.getStackTrace((Throwable)throwable));
        }
        this.addEventData("traceId", TraceContext.traceId());
        return this.gson.toJson(this.logEventMap) + "\n";
    }

    private void addEventData(String keyname, Object keyval) {
        if (null != keyval) {
            this.logEventMap.put(keyname, keyval);
        }
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public static String dateFormat(long timestamp) {
        return DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(timestamp);
    }

    public void activateOptions() {
    }
}

