/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.spring.logging.log4j2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;

@Plugin(name="TraceIdJsonLayout", category="Core", elementType="layout", printObject=true)
public class TraceIdJsonLayout
extends AbstractStringLayout {
    public static final String SYSTEM_ENV_PROP_KEY = "logging.layout";
    public static final String SYSTEM_ENV_PROP_VALUE = "JsonLayout";
    public static final DateTimeFormatter DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.of("GMT+8"));
    private final Gson gson = new GsonBuilder().create();
    private LinkedHashMap<String, Object> logEventMap = new LinkedHashMap();

    protected TraceIdJsonLayout(boolean locationInfo, boolean properties, boolean complete, Charset charset) {
        super(charset);
        System.setProperty(SYSTEM_ENV_PROP_KEY, SYSTEM_ENV_PROP_VALUE);
    }

    @PluginFactory
    public static TraceIdJsonLayout createLayout(@PluginAttribute(value="locationInfo") boolean locationInfo, @PluginAttribute(value="properties") boolean properties, @PluginAttribute(value="complete") boolean complete, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset) {
        return new TraceIdJsonLayout(locationInfo, properties, complete, charset);
    }

    public String toSerializable(LogEvent event) {
        this.logEventMap.clear();
        Instant instant = event.getInstant();
        this.addEventData("timestamp", DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(java.time.Instant.ofEpochMilli(instant.getEpochMillisecond())));
        this.addEventData("level", event.getLevel().toString());
        this.addEventData("thread", event.getThreadName());
        this.addEventData("logger", event.getLoggerName());
        this.addEventData("message", event.getMessage().getFormattedMessage());
        if (event.getThrown() != null) {
            this.addEventData("exception", ExceptionUtils.getStackTrace((Throwable)event.getThrown()));
        }
        this.addEventData("traceId", TraceContext.traceId());
        return this.gson.toJson(this.logEventMap) + "\n";
    }

    private void addEventData(String keyname, Object keyval) {
        if (null != keyval) {
            this.logEventMap.put(keyname, keyval);
        }
    }
}

