/*
 * Decompiled with CFR 0.152.
 */
package cn.com.pg.paas.monitor.spring.model;

import cn.com.pg.paas.monitor.spring.common.ChannelEnum;
import cn.com.pg.paas.monitor.spring.common.MetricTaskEnum;
import cn.com.pg.paas.monitor.spring.model.ServiceInfo;
import cn.com.pg.paas.monitor.spring.model.TaskInfo;
import cn.com.pg.paas.monitor.spring.model.TaskStatus;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;

public class OrderMetric {
    @SerializedName(value="app_name")
    String appName = "sc-order-fulfillment";
    @SerializedName(value="service_info")
    private ServiceInfo serviceInfo;
    @SerializedName(value="task_info")
    private TaskInfo taskInfo;
    @SerializedName(value="channel_order_id")
    private String channelOrderId;
    @SerializedName(value="order_id")
    private String orderId;
    @SerializedName(value="create_date")
    private String createDate = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
    @SerializedName(value="dimensions")
    private Map<String, Object> dimensions;

    OrderMetric(ServiceInfo serviceInfo, TaskInfo taskInfo, String channelOrderId, String orderId, Map<String, Object> dimensions) {
        this.serviceInfo = serviceInfo;
        this.taskInfo = taskInfo;
        this.channelOrderId = channelOrderId;
        this.orderId = orderId;
        this.dimensions = dimensions;
    }

    public static OrderMetricBuilder builder() {
        return new OrderMetricBuilder();
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public String getChannelOrderId() {
        return this.channelOrderId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public Map<String, Object> getDimensions() {
        return this.dimensions;
    }

    public void setServiceInfo(ServiceInfo serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    public void setChannel(String channelName) {
        this.serviceInfo.setChannelName(ChannelEnum.fromStr(channelName));
    }

    public void setChannel(ChannelEnum channelEnum) {
        this.serviceInfo.setChannelName(channelEnum);
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public void setTaskInfo(TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    public void setChannelOrderId(String channelOrderId) {
        this.channelOrderId = channelOrderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setDimensions(Map<String, Object> dimensions) {
        this.dimensions = dimensions;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskInfo.setTaskStatus(taskStatus);
    }

    public void setTaskProcessTime(long processTime) {
        this.taskInfo.setProcessTime(processTime);
    }

    public void addDimension(String key, Object value) {
        if (this.dimensions == null) {
            this.dimensions = new HashMap<String, Object>();
        }
        this.dimensions.put(key, value);
    }

    public String toString() {
        return "OrderMetric{appName='" + this.appName + '\'' + ", serviceInfo=" + this.serviceInfo + ", taskInfo=" + this.taskInfo + ", channelOrderId='" + this.channelOrderId + '\'' + ", orderId='" + this.orderId + '\'' + ", createDate='" + this.createDate + '\'' + ", dimensions=" + this.dimensions + '}';
    }

    public static class OrderMetricBuilder {
        private ServiceInfo serviceInfo;
        private TaskInfo taskInfo;
        private String channelOrderId;
        private String orderId;
        private Map<String, Object> dimensions;

        OrderMetricBuilder() {
        }

        public OrderMetricBuilder serviceInfo(String serviceName, ChannelEnum channel, String tenantCode) {
            this.serviceInfo = new ServiceInfo(serviceName, channel, tenantCode);
            return this;
        }

        public OrderMetricBuilder task(MetricTaskEnum taskEnum, TaskStatus taskStatus) {
            this.taskInfo = new TaskInfo(taskEnum, taskStatus);
            return this;
        }

        public OrderMetricBuilder task(int taskOrder, String taskId, String taskName, TaskStatus taskStatus) {
            this.taskInfo = new TaskInfo(taskOrder, taskId, taskName, taskStatus);
            return this;
        }

        public OrderMetricBuilder channelOrderId(String channelOrderId) {
            this.channelOrderId = channelOrderId;
            return this;
        }

        public OrderMetricBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public OrderMetricBuilder dimensions(Map<String, Object> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public OrderMetricBuilder addDimension(String key, Object obj) {
            if (this.dimensions == null) {
                this.dimensions = new HashMap<String, Object>();
            }
            this.dimensions.put(key, obj);
            return this;
        }

        public OrderMetric build() {
            return new OrderMetric(this.serviceInfo, this.taskInfo, this.channelOrderId, this.orderId, this.dimensions);
        }
    }
}

