/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine;

import cn.hutool.core.lang.Singleton;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.ServiceLoaderUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.log.StaticLog;

public class TemplateFactory {
    public static TemplateEngine get() {
        return (TemplateEngine)Singleton.get((String)TemplateEngine.class.getName(), TemplateFactory::create);
    }

    public static TemplateEngine create() {
        return TemplateFactory.create(new TemplateConfig());
    }

    public static TemplateEngine create(TemplateConfig config) {
        TemplateEngine engine = TemplateFactory.doCreate(config);
        StaticLog.debug((String)"Use [{}] Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    private static TemplateEngine doCreate(TemplateConfig config) {
        Class<? extends TemplateEngine> customEngineClass = config.getCustomEngine();
        TemplateEngine engine = null != customEngineClass ? (TemplateEngine)ReflectUtil.newInstance(customEngineClass, (Object[])new Object[0]) : (TemplateEngine)ServiceLoaderUtil.loadFirstAvailable(TemplateEngine.class);
        if (null != engine) {
            return engine.init(config);
        }
        throw new TemplateException("No template found ! Please add one of template jar to your project !");
    }
}

