/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine.enjoy;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.engine.enjoy.EnjoyTemplate;
import com.jfinal.template.Engine;
import com.jfinal.template.source.FileSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import java.io.File;

public class EnjoyEngine
implements TemplateEngine {
    private Engine engine;
    private TemplateConfig.ResourceMode resourceMode;

    public EnjoyEngine() {
    }

    public EnjoyEngine(TemplateConfig config) {
        this.init(config);
    }

    public EnjoyEngine(Engine engine) {
        this.init(engine);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.resourceMode = config.getResourceMode();
        this.init(EnjoyEngine.createEngine(config));
        return this;
    }

    private void init(Engine engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        if (ObjectUtil.equal((Object)((Object)TemplateConfig.ResourceMode.STRING), (Object)((Object)this.resourceMode))) {
            return EnjoyTemplate.wrap(this.engine.getTemplateByString(resource));
        }
        return EnjoyTemplate.wrap(this.engine.getTemplate(resource));
    }

    public Engine getRawEngine() {
        return this.engine;
    }

    private static Engine createEngine(TemplateConfig config) {
        Engine engine = Engine.create((String)("Hutool-Enjoy-Engine-" + IdUtil.fastSimpleUUID()));
        engine.setEncoding(config.getCharsetStr());
        switch (config.getResourceMode()) {
            case STRING: {
                break;
            }
            case CLASSPATH: {
                engine.setToClassPathSourceFactory();
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case FILE: {
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case WEB_ROOT: {
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                File root = FileUtil.file((File)FileUtil.getWebRoot(), (String)config.getPath());
                engine.setBaseTemplatePath(FileUtil.getAbsolutePath((File)root));
                break;
            }
        }
        return engine;
    }
}

