/*
 * Decompiled with CFR 0.152.
 */
package io.rong.example.message;

import io.rong.RongCloud;
import io.rong.messages.CustomTxtMessage;
import io.rong.messages.TxtMessage;
import io.rong.messages.VoiceMessage;
import io.rong.methods.message._private.Private;
import io.rong.methods.message.chatroom.Chatroom;
import io.rong.methods.message.discussion.Discussion;
import io.rong.methods.message.group.Group;
import io.rong.methods.message.history.History;
import io.rong.methods.message.system.MsgSystem;
import io.rong.models.message.BroadcastMessage;
import io.rong.models.message.ChatroomMessage;
import io.rong.models.message.DiscussionMessage;
import io.rong.models.message.GroupMessage;
import io.rong.models.message.MentionMessage;
import io.rong.models.message.MentionMessageContent;
import io.rong.models.message.MentionedInfo;
import io.rong.models.message.PrivateMessage;
import io.rong.models.message.RecallMessage;
import io.rong.models.message.SystemMessage;
import io.rong.models.message.TemplateMessage;
import io.rong.models.response.HistoryMessageResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.GsonUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;

public class MessageExample {
    private static final String JSONFILE = MessageExample.class.getClassLoader().getResource("jsonsource").getPath() + "/";
    private static final String appKey = "8luwapkv8s7pl";
    private static final String appSecret = "lmkgpHuXezTjV2";
    private static final TxtMessage txtMessage = new TxtMessage("hello", "helloExtra");
    private static final VoiceMessage voiceMessage = new VoiceMessage("hello", "helloExtra", 20L);
    private static final String api = "http://api.cn.ronghub.com";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        RongCloud rongCloud = RongCloud.getInstance(appKey, appSecret);
        Private Private2 = rongCloud.message.msgPrivate;
        MsgSystem system = rongCloud.message.system;
        Group group = rongCloud.message.group;
        Chatroom chatroom = rongCloud.message.chatroom;
        Discussion discussion = rongCloud.message.discussion;
        History history = rongCloud.message.history;
        String[] targetIds = new String[]{"2651280140445094444"};
        SystemMessage systemMessage = new SystemMessage().setSenderId("usetId").setTargetId(targetIds).setObjectName(txtMessage.getType()).setContent(txtMessage).setPushContent("this is a push").setPushData("{'pushData':'hello'}").setIsPersisted(0).setIsCounted(0).setContentAvailable(0);
        ResponseResult result = system.send(systemMessage);
        System.out.println("send system message:  " + result.toString());
        Reader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(MessageExample.class.getClassLoader().getResourceAsStream("jsonsource/message/TemplateMessage.json")));
            TemplateMessage template = (TemplateMessage)GsonUtil.fromJson(reader, TemplateMessage.class);
            ResponseResult systemTemplateResult = system.sendTemplate(template);
            System.out.println("send system template message:  " + systemTemplateResult.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        BroadcastMessage message = new BroadcastMessage().setSenderId("Hji8yh76").setObjectName(txtMessage.getType()).setContent(txtMessage).setPushContent("this is a push").setPushData("{'pushData':'hello'}").setOs("iOS");
        ResponseResult broadcastResult = rongCloud.message.system.broadcast(message);
        System.out.println("send broadcast:  " + broadcastResult.toString());
        PrivateMessage privateMessage = new PrivateMessage().setSenderId("2609751433442958892").setTargetId(targetIds).setObjectName(voiceMessage.getType()).setContent(voiceMessage).setPushContent("").setPushData("{\"pushData\":\"hello\"}").setCount("4").setVerifyBlacklist(0).setIsPersisted(0).setIsCounted(0).setIsIncludeSender(0);
        ResponseResult privateResult = Private2.send(privateMessage);
        System.out.println("send private message:  " + privateResult.toString());
        try {
            reader = new BufferedReader(new InputStreamReader(MessageExample.class.getClassLoader().getResourceAsStream("jsonsource/message/TemplateMessage.json")));
            TemplateMessage template = (TemplateMessage)GsonUtil.fromJson(reader, TemplateMessage.class);
            ResponseResult messagePublishTemplateResult = Private2.sendTemplate(template);
            System.out.println("send privateTemplate message:  " + messagePublishTemplateResult.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        RecallMessage recallMessage = new RecallMessage().setSenderId("2609751433442958892").setTargetId("2651280140445094444").setuId("5H6P-CGC6-44QR-VB3R").setSentTime("1519444243981");
        ResponseResult recallPrivateResult = (ResponseResult)Private2.recall(recallMessage);
        System.out.println("recall private:  " + recallPrivateResult.toString());
        GroupMessage groupMessage = new GroupMessage().setSenderId("userId").setTargetId(targetIds).setObjectName(txtMessage.getType()).setContent(txtMessage).setPushContent("this is a push").setPushData("{\"pushData\":\"hello\"}").setIsPersisted(0).setIsCounted(0).setIsIncludeSender(0).setContentAvailable(0);
        ResponseResult groupResult = group.send(groupMessage);
        System.out.println("send Group message:  " + groupResult.toString());
        recallMessage = new RecallMessage().setSenderId("sea9901").setTargetId("markoiwm").setuId("5GSB-RPM1-KP8H-9JHF").setSentTime("1522242030641");
        ResponseResult recallMessageResult = (ResponseResult)group.recall(recallMessage);
        System.out.println("send recall group message:  " + recallMessageResult.toString());
        String[] mentionIds = new String[]{"Hji8yh76", "sea9901"};
        MentionedInfo mentionedInfo = new MentionedInfo(1, mentionIds, "");
        MentionMessageContent content = new MentionMessageContent(txtMessage, mentionedInfo);
        MentionMessage mentionMessage = new MentionMessage().setSenderId("userId").setTargetId(targetIds).setObjectName(txtMessage.getType()).setContent(content).setPushContent("this is a push").setPushData("{\"pushData\":\"hello\"}").setIsPersisted(0).setIsCounted(0).setIsIncludeSender(0).setContentAvailable(0);
        ResponseResult mentionResult = rongCloud.message.group.sendMention(mentionMessage);
        System.out.println("group mention result:  " + mentionResult.toString());
        String[] discussionIds = new String[]{"lijhGk87", "lijhGk88"};
        DiscussionMessage discussionMessage = new DiscussionMessage().setSenderId("JuikH78ko").setTargetId(discussionIds).setObjectName(txtMessage.getType()).setContent(txtMessage).setPushContent("this is a push").setPushData("{\"pushData\":\"hello\"}").setIsPersisted(0).setIsCounted(0).setIsIncludeSender(0).setContentAvailable(0);
        ResponseResult discussionResult = discussion.send(discussionMessage);
        System.out.println("send discussion message:  " + discussionResult.toString());
        recallMessage = new RecallMessage().setSenderId("sea9901").setTargetId("IXQhMs3ny").setuId("5GSB-RPM1-KP8H-9JHF").setSentTime("1519444243981");
        ResponseResult recallDiscussionResult = (ResponseResult)discussion.recall(recallMessage);
        System.out.println("recall discussion message:  " + recallDiscussionResult.toString());
        String[] chatroomIds = new String[]{"15222258878654823358"};
        CustomTxtMessage ctm = new CustomTxtMessage("hello");
        ChatroomMessage chatroomMessage = new ChatroomMessage().setSenderId("1").setTargetId(chatroomIds).setContent(ctm).setObjectName(ctm.getType());
        ResponseResult chatroomResult = chatroom.send(chatroomMessage);
        System.out.println("send chatroom message:  " + chatroomResult.toString());
        chatroomMessage = new ChatroomMessage().setSenderId("bN6oQi8T5").setContent(txtMessage).setObjectName(txtMessage.getType());
        ResponseResult chatroomBroadcastresult = chatroom.broadcast(chatroomMessage);
        System.out.println("send chatroom broadcast message:  " + chatroomBroadcastresult.toString());
        HistoryMessageResult historyMessageResult = history.get("2018032810");
        System.out.println("get history  message:  " + historyMessageResult.toString());
        ResponseResult removeHistoryMessageResult = history.remove("2018030210");
        System.out.println("remove history  message:  " + removeHistoryMessageResult.toString());
    }
}

