/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.resource.modular.factory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.resource.api.pojo.resource.FieldMetadata;
import cn.stylefeng.roses.kernel.resource.api.pojo.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.resource.modular.entity.SysResource;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Map;
import java.util.Set;

public class ResourceFactory {
    public static SysResource createResource(ResourceDefinition resourceDefinition) {
        SysResource resource = new SysResource();
        BeanUtil.copyProperties((Object)resourceDefinition, (Object)((Object)resource), (CopyOptions)CopyOptions.create().ignoreError());
        resource.setResourceCode(resourceDefinition.getResourceCode());
        if (resourceDefinition.getRequiredLoginFlag().booleanValue()) {
            resource.setRequiredLoginFlag(YesOrNotEnum.Y.name());
        } else {
            resource.setRequiredLoginFlag(YesOrNotEnum.N.name());
        }
        if (resourceDefinition.getRequiredPermissionFlag().booleanValue()) {
            resource.setRequiredPermissionFlag(YesOrNotEnum.Y.name());
        } else {
            resource.setRequiredPermissionFlag(YesOrNotEnum.N.name());
        }
        if (resourceDefinition.getViewFlag().booleanValue()) {
            resource.setViewFlag(YesOrNotEnum.Y.name());
        } else {
            resource.setViewFlag(YesOrNotEnum.N.name());
        }
        if (ObjectUtil.isNotEmpty((Object)resourceDefinition.getValidateGroups())) {
            resource.setValidateGroups(JSON.toJSONString((Object)resourceDefinition.getValidateGroups(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        }
        if (ObjectUtil.isNotEmpty((Object)resourceDefinition.getParamFieldDescriptions())) {
            resource.setParamFieldDescriptions(JSON.toJSONString((Object)resourceDefinition.getParamFieldDescriptions(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        }
        if (ObjectUtil.isNotEmpty((Object)resourceDefinition.getResponseFieldDescriptions())) {
            resource.setResponseFieldDescriptions(JSON.toJSONString((Object)resourceDefinition.getResponseFieldDescriptions(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        }
        return resource;
    }

    public static ResourceDefinition createResourceDefinition(SysResource sysResource) {
        ResourceDefinition resourceDefinition = new ResourceDefinition();
        BeanUtil.copyProperties((Object)((Object)sysResource), (Object)resourceDefinition, (CopyOptions)CopyOptions.create().ignoreError());
        resourceDefinition.setRequiredLoginFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(sysResource.getRequiredLoginFlag())));
        resourceDefinition.setRequiredPermissionFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(sysResource.getRequiredPermissionFlag())));
        resourceDefinition.setViewFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(sysResource.getViewFlag())));
        if (ObjectUtil.isNotEmpty((Object)sysResource.getValidateGroups())) {
            resourceDefinition.setValidateGroups((Set)JSON.parseObject((String)sysResource.getValidateGroups(), Set.class, (Feature[])new Feature[]{Feature.SupportAutoType}));
        }
        if (ObjectUtil.isNotEmpty((Object)sysResource.getParamFieldDescriptions())) {
            resourceDefinition.setParamFieldDescriptions((Set)JSON.parseObject((String)sysResource.getParamFieldDescriptions(), Set.class, (Feature[])new Feature[]{Feature.SupportAutoType}));
        }
        if (ObjectUtil.isNotEmpty((Object)sysResource.getResponseFieldDescriptions())) {
            resourceDefinition.setResponseFieldDescriptions((Set)JSON.parseObject((String)sysResource.getResponseFieldDescriptions(), Set.class, (Feature[])new Feature[]{Feature.SupportAutoType}));
        }
        return resourceDefinition;
    }

    public static ResourceDefinition fillResourceDetail(ResourceDefinition resourceDefinition) {
        Set validateGroups = resourceDefinition.getValidateGroups();
        Set paramFieldDescriptions = resourceDefinition.getParamFieldDescriptions();
        ResourceFactory.fillDetailMessage(validateGroups, paramFieldDescriptions);
        Set responseFieldDescriptions = resourceDefinition.getResponseFieldDescriptions();
        ResourceFactory.fillDetailMessage(validateGroups, responseFieldDescriptions);
        return resourceDefinition;
    }

    public static Set<FieldMetadata> fillDetailMessage(Set<String> validateGroups, Set<FieldMetadata> fieldMetadataSet) {
        if (validateGroups == null || validateGroups.isEmpty()) {
            return fieldMetadataSet;
        }
        if (fieldMetadataSet == null || fieldMetadataSet.isEmpty()) {
            return fieldMetadataSet;
        }
        for (FieldMetadata fieldMetadata : fieldMetadataSet) {
            StringBuilder finalValidateMessages = new StringBuilder();
            Map groupAnnotations = fieldMetadata.getGroupValidationMessage();
            if (groupAnnotations != null) {
                for (String validateGroup : validateGroups) {
                    Set validateMessage = (Set)groupAnnotations.get(validateGroup);
                    if (validateMessage == null || validateMessage.isEmpty()) continue;
                    finalValidateMessages.append(StrUtil.join((CharSequence)"\uff0c", (Object[])new Object[]{validateMessage}));
                }
            }
            fieldMetadata.setValidationMessages(finalValidateMessages.toString());
            if (fieldMetadata.getGenericFieldMetadata() == null || fieldMetadata.getGenericFieldMetadata().isEmpty()) continue;
            ResourceFactory.fillDetailMessage(validateGroups, fieldMetadata.getGenericFieldMetadata());
        }
        return fieldMetadataSet;
    }
}

