/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.resource.modular.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.LoginUserApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.basic.SimpleRoleInfo;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.resource.api.ResourceReportApi;
import cn.stylefeng.roses.kernel.resource.api.pojo.resource.ReportResourceParam;
import cn.stylefeng.roses.kernel.resource.api.pojo.resource.ResourceDefinition;
import cn.stylefeng.roses.kernel.resource.api.pojo.resource.ResourceUrlParam;
import cn.stylefeng.roses.kernel.resource.modular.cache.ResourceCache;
import cn.stylefeng.roses.kernel.resource.modular.entity.SysResource;
import cn.stylefeng.roses.kernel.resource.modular.factory.ResourceFactory;
import cn.stylefeng.roses.kernel.resource.modular.mapper.SysResourceMapper;
import cn.stylefeng.roses.kernel.resource.modular.pojo.ResourceTreeNode;
import cn.stylefeng.roses.kernel.resource.modular.service.SysResourceService;
import cn.stylefeng.roses.kernel.rule.constants.RuleConstants;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.system.ResourceServiceApi;
import cn.stylefeng.roses.kernel.system.RoleServiceApi;
import cn.stylefeng.roses.kernel.system.pojo.resource.LayuiApiResourceTreeNode;
import cn.stylefeng.roses.kernel.system.pojo.resource.ResourceRequest;
import cn.stylefeng.roses.kernel.system.pojo.role.dto.SysRoleResourceDTO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class SysResourceServiceImpl
extends ServiceImpl<SysResourceMapper, SysResource>
implements SysResourceService,
ResourceReportApi,
ResourceServiceApi {
    @Resource
    private SysResourceMapper resourceMapper;
    @Resource
    private ResourceCache resourceCache;
    @Resource
    private RoleServiceApi roleServiceApi;

    @Override
    public PageResult<SysResource> findPage(ResourceRequest resourceRequest) {
        LambdaQueryWrapper<SysResource> wrapper = this.createWrapper(resourceRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysResource> findList(ResourceRequest resourceRequest) {
        LambdaQueryWrapper<SysResource> wrapper = this.createWrapper(resourceRequest);
        wrapper.select(new SFunction[]{SysResource::getResourceCode, SysResource::getResourceName});
        List menuResourceList = this.list((Wrapper)wrapper);
        SysResource sysResource = new SysResource();
        sysResource.setResourceCode("");
        sysResource.setResourceName("\u865a\u62df\u76ee\u5f55(\u7a7a)");
        menuResourceList.add(0, sysResource);
        return menuResourceList;
    }

    @Override
    public List<ResourceTreeNode> getResourceTree(Long roleId, Boolean lateralFlag) {
        List roleIds;
        List resourceCodeList;
        ArrayList<ResourceTreeNode> res = new ArrayList<ResourceTreeNode>();
        LambdaQueryWrapper sysResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        sysResourceLambdaQueryWrapper.select(new SFunction[]{SysResource::getAppCode, SysResource::getModularCode, SysResource::getModularName, SysResource::getResourceCode, SysResource::getUrl, SysResource::getResourceName});
        sysResourceLambdaQueryWrapper.eq(SysResource::getRequiredPermissionFlag, (Object)YesOrNotEnum.Y.getCode());
        LoginUserApi loginUserApi = LoginContext.me();
        if (!loginUserApi.getSuperAdminFlag() && !(resourceCodeList = this.roleServiceApi.getRoleResourceCodeList(roleIds = loginUserApi.getLoginUser().getSimpleRoleInfoList().parallelStream().map(SimpleRoleInfo::getRoleId).collect(Collectors.toList()))).isEmpty()) {
            sysResourceLambdaQueryWrapper.in(SysResource::getResourceCode, (Collection)resourceCodeList);
        }
        List allResource = this.list((Wrapper)sysResourceLambdaQueryWrapper);
        List resourceList = this.roleServiceApi.getRoleResourceList(Collections.singletonList(roleId));
        HashMap<String, SysRoleResourceDTO> alreadyHave = new HashMap<String, SysRoleResourceDTO>(resourceList.size());
        for (SysRoleResourceDTO sysRoleResponse : resourceList) {
            alreadyHave.put(sysRoleResponse.getResourceCode(), sysRoleResponse);
        }
        HashMap<String, ArrayList<SysResource>> modularMap = new HashMap<String, ArrayList<SysResource>>();
        for (SysResource sysResource : allResource) {
            ArrayList<SysResource> sysResources = (ArrayList<SysResource>)modularMap.get(sysResource.getModularName());
            if (ObjectUtil.isEmpty((Object)sysResources)) {
                sysResources = new ArrayList<SysResource>();
                modularMap.put(sysResource.getModularName(), sysResources);
            }
            sysResources.add(sysResource);
        }
        for (Map.Entry entry : modularMap.entrySet()) {
            ResourceTreeNode item = new ResourceTreeNode();
            item.setResourceFlag(false);
            String id = IdWorker.get32UUID();
            item.setCode(id);
            item.setParentCode(RuleConstants.TREE_ROOT_ID.toString());
            item.setNodeName((String)entry.getKey());
            item.setChecked(false);
            for (SysResource resource : (List)entry.getValue()) {
                ResourceTreeNode subItem = new ResourceTreeNode();
                SysRoleResourceDTO resourceResponse = (SysRoleResourceDTO)alreadyHave.get(resource.getResourceCode());
                if (ObjectUtil.isEmpty((Object)resourceResponse)) {
                    subItem.setChecked(false);
                } else {
                    item.setChecked(true);
                    subItem.setChecked(true);
                }
                subItem.setResourceFlag(true);
                subItem.setNodeName(resource.getResourceName());
                subItem.setCode(resource.getResourceCode());
                subItem.setParentCode(id);
                res.add(subItem);
            }
            res.add(item);
        }
        if (lateralFlag.booleanValue()) {
            return res;
        }
        return new DefaultTreeBuildFactory().doTreeBuild(res);
    }

    @Override
    public List<LayuiApiResourceTreeNode> getApiResourceTree() {
        LambdaQueryWrapper sysResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        sysResourceLambdaQueryWrapper.eq(SysResource::getViewFlag, (Object)YesOrNotEnum.N.getCode());
        sysResourceLambdaQueryWrapper.select(new SFunction[]{SysResource::getAppCode, SysResource::getModularCode, SysResource::getModularName, SysResource::getResourceCode, SysResource::getUrl, SysResource::getResourceName});
        List allResource = this.list((Wrapper)sysResourceLambdaQueryWrapper);
        Map<String, Map<String, List<LayuiApiResourceTreeNode>>> appModularResources = this.divideResources(allResource);
        Map<String, String> modularCodeName = this.createModularCodeName(allResource);
        return this.createResourceTree(appModularResources, modularCodeName);
    }

    @Override
    public ResourceDefinition getApiResourceDetail(ResourceRequest resourceRequest) {
        LambdaQueryWrapper sysResourceLambdaQueryWrapper = new LambdaQueryWrapper();
        sysResourceLambdaQueryWrapper.eq(SysResource::getResourceCode, (Object)resourceRequest.getResourceCode());
        SysResource sysResource = (SysResource)((Object)this.getOne((Wrapper)sysResourceLambdaQueryWrapper));
        if (sysResource != null) {
            ResourceDefinition resourceDefinition = ResourceFactory.createResourceDefinition(sysResource);
            return ResourceFactory.fillResourceDetail(resourceDefinition);
        }
        return null;
    }

    @Override
    public void deleteResourceByProjectCode(String projectCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysResource::getProjectCode, (Object)projectCode);
        this.remove((Wrapper)wrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void reportResources(@RequestBody ReportResourceParam reportResourceReq) {
        String projectCode = reportResourceReq.getProjectCode();
        Map resourceDefinitions = reportResourceReq.getResourceDefinitions();
        if (ObjectUtil.isEmpty((Object)projectCode) || resourceDefinitions == null) {
            return;
        }
        this.deleteResourceByProjectCode(projectCode);
        ArrayList<SysResource> allResources = new ArrayList<SysResource>();
        for (Map.Entry appModularResources : resourceDefinitions.entrySet()) {
            Map value = (Map)appModularResources.getValue();
            for (Map.Entry modularResources : value.entrySet()) {
                SysResource resource = ResourceFactory.createResource((ResourceDefinition)modularResources.getValue());
                allResources.add(resource);
            }
        }
        this.saveBatch(allResources, allResources.size());
        this.resourceCache.saveResourcesToCache(allResources);
    }

    public ResourceDefinition getResourceByUrl(@RequestBody ResourceUrlParam resourceUrlReq) {
        if (ObjectUtil.isEmpty((Object)resourceUrlReq.getUrl())) {
            return null;
        }
        List resources = this.resourceMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"url", (Object)resourceUrlReq.getUrl()));
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        SysResource resource = (SysResource)((Object)resources.get(0));
        ResourceDefinition resourceDefinition = new ResourceDefinition();
        BeanUtils.copyProperties((Object)((Object)resource), (Object)resourceDefinition);
        String requiredLoginFlag = resource.getRequiredLoginFlag();
        resourceDefinition.setRequiredLoginFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(requiredLoginFlag)));
        String requiredPermissionFlag = resource.getRequiredPermissionFlag();
        resourceDefinition.setRequiredPermissionFlag(Boolean.valueOf(YesOrNotEnum.Y.name().equals(requiredPermissionFlag)));
        return resourceDefinition;
    }

    public Set<String> getResourceUrlsListByCodes(List<String> resourceCodes) {
        if (resourceCodes == null || resourceCodes.isEmpty()) {
            return new HashSet<String>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysResource::getResourceCode, resourceCodes);
        queryWrapper.select(new SFunction[]{SysResource::getUrl});
        List list = this.list((Wrapper)queryWrapper);
        return list.stream().map(SysResource::getUrl).collect(Collectors.toSet());
    }

    private LambdaQueryWrapper<SysResource> createWrapper(ResourceRequest resourceRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isEmpty((Object)resourceRequest)) {
            return queryWrapper;
        }
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)resourceRequest.getAppCode()), SysResource::getAppCode, (Object)resourceRequest.getAppCode());
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)resourceRequest.getResourceName()), SysResource::getResourceName, (Object)resourceRequest.getResourceName());
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)resourceRequest.getUrl()), SysResource::getUrl, (Object)resourceRequest.getUrl());
        return queryWrapper;
    }

    private Map<String, Map<String, List<LayuiApiResourceTreeNode>>> divideResources(List<SysResource> sysResources) {
        HashMap<String, Map<String, List<LayuiApiResourceTreeNode>>> appModularResources = new HashMap<String, Map<String, List<LayuiApiResourceTreeNode>>>();
        for (SysResource sysResource : sysResources) {
            List<LayuiApiResourceTreeNode> resourceTreeNodes;
            String appCode = sysResource.getAppCode();
            Map<String, List<LayuiApiResourceTreeNode>> modularResource = appModularResources.get(appCode);
            if (modularResource == null) {
                modularResource = new HashMap<String, List<LayuiApiResourceTreeNode>>();
            }
            if ((resourceTreeNodes = modularResource.get(sysResource.getModularCode())) == null) {
                resourceTreeNodes = new ArrayList<LayuiApiResourceTreeNode>();
            }
            LayuiApiResourceTreeNode resourceTreeNode = new LayuiApiResourceTreeNode();
            resourceTreeNode.setResourceFlag(Boolean.valueOf(true));
            resourceTreeNode.setTitle(sysResource.getResourceName());
            resourceTreeNode.setId(sysResource.getResourceCode());
            resourceTreeNode.setParentId(sysResource.getModularCode());
            resourceTreeNode.setSpread(Boolean.valueOf(false));
            resourceTreeNodes.add(resourceTreeNode);
            modularResource.put(sysResource.getModularCode(), resourceTreeNodes);
            appModularResources.put(appCode, modularResource);
        }
        return appModularResources;
    }

    private Map<String, String> createModularCodeName(List<SysResource> resources) {
        HashMap<String, String> modularCodeName = new HashMap<String, String>();
        for (SysResource resource : resources) {
            modularCodeName.put(resource.getModularCode(), resource.getModularName());
        }
        return modularCodeName;
    }

    private List<LayuiApiResourceTreeNode> createResourceTree(Map<String, Map<String, List<LayuiApiResourceTreeNode>>> appModularResources, Map<String, String> modularCodeName) {
        ArrayList<LayuiApiResourceTreeNode> finalTree = new ArrayList<LayuiApiResourceTreeNode>();
        for (String appName : appModularResources.keySet()) {
            LayuiApiResourceTreeNode appNode = new LayuiApiResourceTreeNode();
            appNode.setId(appName);
            appNode.setTitle(appName);
            appNode.setSpread(Boolean.valueOf(true));
            appNode.setResourceFlag(Boolean.valueOf(false));
            appNode.setParentId(TreeConstants.DEFAULT_PARENT_ID.toString());
            Map<String, List<LayuiApiResourceTreeNode>> modularResources = appModularResources.get(appName);
            ArrayList<LayuiApiResourceTreeNode> modularNodes = new ArrayList<LayuiApiResourceTreeNode>();
            for (String modularCode : modularResources.keySet()) {
                LayuiApiResourceTreeNode modularNode = new LayuiApiResourceTreeNode();
                modularNode.setId(modularCode);
                modularNode.setTitle(modularCodeName.get(modularCode));
                modularNode.setParentId(appName);
                modularNode.setSpread(Boolean.valueOf(false));
                modularNode.setResourceFlag(Boolean.valueOf(false));
                modularNode.setChildren(modularResources.get(modularCode));
                modularNodes.add(modularNode);
            }
            appNode.setChildren(modularNodes);
            finalTree.add(appNode);
        }
        return finalTree;
    }
}

