/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.elasticsearch.enrich.EnrichPolicy;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class EnrichConfiguration
implements JsonpSerializable {
    @Nullable
    private final EnrichPolicy geoMatch;
    private final EnrichPolicy match;
    private final EnrichPolicy range;
    public static final JsonpDeserializer<EnrichConfiguration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EnrichConfiguration::setupEnrichConfigurationDeserializer);

    private EnrichConfiguration(Builder builder) {
        this.geoMatch = builder.geoMatch;
        this.match = ApiTypeHelper.requireNonNull(builder.match, this, "match");
        this.range = ApiTypeHelper.requireNonNull(builder.range, this, "range");
    }

    public static EnrichConfiguration of(Function<Builder, ObjectBuilder<EnrichConfiguration>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final EnrichPolicy geoMatch() {
        return this.geoMatch;
    }

    public final EnrichPolicy match() {
        return this.match;
    }

    public final EnrichPolicy range() {
        return this.range;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.geoMatch != null) {
            generator.writeKey("geo_match");
            this.geoMatch.serialize(generator, mapper);
        }
        generator.writeKey("match");
        this.match.serialize(generator, mapper);
        generator.writeKey("range");
        this.range.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupEnrichConfigurationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::geoMatch, EnrichPolicy._DESERIALIZER, "geo_match");
        op.add(Builder::match, EnrichPolicy._DESERIALIZER, "match");
        op.add(Builder::range, EnrichPolicy._DESERIALIZER, "range");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<EnrichConfiguration> {
        @Nullable
        private EnrichPolicy geoMatch;
        private EnrichPolicy match;
        private EnrichPolicy range;

        public final Builder geoMatch(@Nullable EnrichPolicy value) {
            this.geoMatch = value;
            return this;
        }

        public final Builder geoMatch(Function<EnrichPolicy.Builder, ObjectBuilder<EnrichPolicy>> fn) {
            return this.geoMatch(fn.apply(new EnrichPolicy.Builder()).build());
        }

        public final Builder match(EnrichPolicy value) {
            this.match = value;
            return this;
        }

        public final Builder match(Function<EnrichPolicy.Builder, ObjectBuilder<EnrichPolicy>> fn) {
            return this.match(fn.apply(new EnrichPolicy.Builder()).build());
        }

        public final Builder range(EnrichPolicy value) {
            this.range = value;
            return this;
        }

        public final Builder range(Function<EnrichPolicy.Builder, ObjectBuilder<EnrichPolicy>> fn) {
            return this.range(fn.apply(new EnrichPolicy.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EnrichConfiguration build() {
            this._checkSingleUse();
            return new EnrichConfiguration(this);
        }
    }
}

