/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.RoleDescriptor;
import co.elastic.clients.elasticsearch.security.UpdateApiKeyResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateApiKeyRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    private final Map<String, JsonData> metadata;
    private final Map<String, RoleDescriptor> roleDescriptors;
    public static final JsonpDeserializer<UpdateApiKeyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateApiKeyRequest::setupUpdateApiKeyRequestDeserializer);
    public static final Endpoint<UpdateApiKeyRequest, UpdateApiKeyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateApiKeyRequest, UpdateApiKeyResponse>("es/security.update_api_key", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/api_key");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateApiKeyResponse._DESERIALIZER);

    private UpdateApiKeyRequest(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.roleDescriptors = ApiTypeHelper.unmodifiable(builder.roleDescriptors);
    }

    public static UpdateApiKeyRequest of(Function<Builder, ObjectBuilder<UpdateApiKeyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final Map<String, RoleDescriptor> roleDescriptors() {
        return this.roleDescriptors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.roleDescriptors)) {
            generator.writeKey("role_descriptors");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.roleDescriptors.entrySet()) {
                generator.writeKey(entry.getKey());
                ((RoleDescriptor)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupUpdateApiKeyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::roleDescriptors, JsonpDeserializer.stringMapDeserializer(RoleDescriptor._DESERIALIZER), "role_descriptors");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UpdateApiKeyRequest> {
        private String id;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Map<String, RoleDescriptor> roleDescriptors;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder roleDescriptors(Map<String, RoleDescriptor> map) {
            this.roleDescriptors = Builder._mapPutAll(this.roleDescriptors, map);
            return this;
        }

        public final Builder roleDescriptors(String key, RoleDescriptor value) {
            this.roleDescriptors = Builder._mapPut(this.roleDescriptors, key, value);
            return this;
        }

        public final Builder roleDescriptors(String key, Function<RoleDescriptor.Builder, ObjectBuilder<RoleDescriptor>> fn) {
            return this.roleDescriptors(key, fn.apply(new RoleDescriptor.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateApiKeyRequest build() {
            this._checkSingleUse();
            return new UpdateApiKeyRequest(this);
        }
    }
}

