/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.concurrent;

import com.alibaba.ageiport.common.concurrent.FutureCallback;
import com.alibaba.ageiport.common.concurrent.InternalFutureFailureAccess;
import com.alibaba.ageiport.common.concurrent.InternalFutures;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class CallbackListener<V>
implements Runnable {
    final Future<V> future;
    final FutureCallback<? super V> callback;

    public CallbackListener(Future<V> future, FutureCallback<? super V> callback) {
        this.future = future;
        this.callback = callback;
    }

    @Override
    public void run() {
        V value;
        Throwable failure;
        if (this.future instanceof InternalFutureFailureAccess && (failure = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((Object)this.future))) != null) {
            this.callback.onFailure(failure);
            return;
        }
        try {
            value = CallbackListener.getDone(this.future);
        }
        catch (ExecutionException e) {
            this.callback.onFailure(e.getCause());
            return;
        }
        catch (Error | RuntimeException e) {
            this.callback.onFailure(e);
            return;
        }
        this.callback.onSuccess(value);
    }

    public static <V> V getDone(Future<V> future) throws ExecutionException {
        if (!future.isDone()) {
            throw new IllegalStateException("Future was expected to be done:" + future);
        }
        return CallbackListener.getUninterruptibly(future);
    }

    public static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean interrupted = false;
        while (true) {
            try {
                V v = future.get();
                return v;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

