/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel;

import com.alibaba.csp.ahas.sentinel.AhasGlobalContext;
import com.alibaba.csp.ahas.sentinel.SentinelRequestHandler;
import com.alibaba.csp.ahas.sentinel.acm.SentinelSdkInitService;
import com.alibaba.csp.ahas.sentinel.acm.SentinelSdkInitServiceManager;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwComponent;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwComponentManager;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwComponentType;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwProductCode;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.SentinelDisabledException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.init.AhasInitFunc;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Response;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.ServiceConstants;
import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.adapter.agent.AgentCompatibilityUtils;
import com.alibaba.csp.sentinel.command.handler.ExecuteShellCommandHandler;
import com.alibaba.csp.sentinel.command.handler.FetchActiveRuleCommandHandler;
import com.alibaba.csp.sentinel.command.handler.FetchJsonTreeCommandHandler;
import com.alibaba.csp.sentinel.command.handler.FetchSimpleClusterNodeCommandHandler;
import com.alibaba.csp.sentinel.command.handler.OnOffGetCommandHandler;
import com.alibaba.csp.sentinel.command.handler.OnOffSetCommandHandler;
import com.alibaba.csp.sentinel.command.handler.SendMetricCommandHandler;
import com.alibaba.csp.sentinel.command.handler.VersionCommandHandler;
import com.alibaba.csp.sentinel.command.handler.cluster.FetchClusterModeCommandHandler;
import com.alibaba.csp.sentinel.command.handler.cluster.ModifyClusterModeCommandHandler;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.setting.handler.FallbackBehaviorCheckCommandHandler;
import com.alibaba.csp.sentinel.spi.SpiOrder;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@SpiOrder(value=-10000)
@InitOrder(value=-2147483648)
public class DefaultSentinelSdkService
implements InitFunc {
    private static final AgwComponent agwComponent = AgwComponentManager.getAgwComponent(AgwProductCode.SENTINEL);
    private static final AtomicBoolean isAhasInit = new AtomicBoolean(false);
    private static final AtomicBoolean ahasInitSuccess = new AtomicBoolean(false);
    private static final ExecutorService INIT_EXECUTOR = Executors.newSingleThreadExecutor(new NamedThreadFactory("AhasSentinelSdkService-init-thread", true));
    private static ScheduledExecutorService hbScheduler = new ScheduledThreadPoolExecutor(2, new NamedThreadFactory("ahas-sentinel-heartbeat-send-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private static DefaultSentinelSdkService defaultSentinelSdkService;
    private static String ahasSdkVersion;

    public static synchronized DefaultSentinelSdkService getInstance() {
        if (defaultSentinelSdkService == null) {
            defaultSentinelSdkService = new DefaultSentinelSdkService();
        }
        return defaultSentinelSdkService;
    }

    public DefaultSentinelSdkService() {
        if (AgentCompatibilityUtils.isAgentPresent()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSentinelSdkService.this.initAhasTransport();
                }
                catch (Throwable e) {
                    RecordLog.warn("[DefaultSentinelSdkService] Failed to initialize AHAS transport", e);
                    System.err.println("ERROR: AHAS init fail");
                }
            }
        };
        INIT_EXECUTOR.submit(runnable);
    }

    @Override
    public void init() throws Exception {
        if (AgentCompatibilityUtils.isAgentPresent()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!ahasInitSuccess.get()) {
                    return;
                }
                try {
                    SentinelSdkInitService sentinelSdkInitService = SentinelSdkInitServiceManager.getInitService(agwComponent.getClientInfoService());
                    sentinelSdkInitService.init(ahasSdkVersion);
                }
                catch (Throwable throwable) {
                    RecordLog.warn("[DefaultSentinelSdkService] Init AHAS Sentinel or ACM error", throwable);
                }
            }
        };
        INIT_EXECUTOR.submit(runnable);
    }

    private void initAhasTransport() throws Exception {
        if (!isAhasInit.compareAndSet(false, true)) {
            return;
        }
        this.registerCommandHandler();
        ahasSdkVersion = "1.10.5_1.10.5";
        System.setProperty("ahas.version", ahasSdkVersion);
        if (AgwComponentManager.isInner() && System.getProperty("ahas.inner.agw.disable") != null) {
            RecordLog.info("ahas.inner.agw.disable detected (inner env), so AHAS agw module will not be initialized", new Object[0]);
            ahasInitSuccess.set(true);
            return;
        }
        int times = 0;
        while (true) {
            try {
                ((AhasInitFunc)((Object)agwComponent.getClientInfoService())).init("JAVA_SDK", null);
                agwComponent.getTransportService().init(agwComponent.getClientInfoService());
                agwComponent.getHeartbeatService().init(agwComponent);
            }
            catch (Throwable throwable) {
                if (throwable instanceof SentinelDisabledException) {
                    RecordLog.warn("[DefaultSentinelSdkService] AHAS Sentinel disabled, stop connect to server.", new Object[0]);
                    throw new SentinelDisabledException("AHAS Sentinel disabled");
                }
                RecordLog.error("[DefaultSentinelSdkService] Failed to init AHAS transport, region={}, will retry (current {}) ", agwComponent.getClientInfoService().getRegionId(), times, throwable);
                if (AgwComponentManager.isInner() && ++times > 3) {
                    AhasGlobalContext.setClientInfoService(agwComponent.getClientInfoService());
                    ahasInitSuccess.set(true);
                    RecordLog.warn("AHAS transport module will be skipped during Sentinel initialization", new Object[0]);
                    return;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
        RecordLog.info("[DefaultSentinelSdkService] AHAS gateway host: " + agwComponent.getClientInfoService().getGatewayHost() + ", port:" + agwComponent.getClientInfoService().getGatewayPort(), new Object[0]);
        AhasGlobalContext.setClientInfoService(agwComponent.getClientInfoService());
        this.initHeartbeatTask();
        ahasInitSuccess.set(true);
        RecordLog.info("AHAS transport has been initialized successfully", new Object[0]);
    }

    private String getAhasVersion(String defaultVersion) {
        String gwVersion = defaultVersion;
        try {
            String version = DefaultSentinelSdkService.class.getPackage().getImplementationVersion();
            if (StringUtil.isNotBlank(version)) {
                gwVersion = version;
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[DefaultSentinelSdkService] Using default AHAS version, ignore exception", e);
        }
        return gwVersion;
    }

    private String getWholeVersion(String ahasVersion) {
        String coreVersion = Constants.SENTINEL_VERSION;
        String wholeVersion = coreVersion + "_" + ahasVersion;
        RecordLog.info("[DefaultSentinelSdkService] wholeVersion: " + wholeVersion, new Object[0]);
        return wholeVersion;
    }

    private void registerCommandHandler() {
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.CLUSTER_NODE.getHandlerName(), new SentinelRequestHandler<String>(new FetchSimpleClusterNodeCommandHandler()));
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.JSON_TREE.getHandlerName(), new SentinelRequestHandler<String>(new FetchJsonTreeCommandHandler()));
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.METRIC.getHandlerName(), new SentinelRequestHandler<String>(new SendMetricCommandHandler()));
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.GET_RULES.getHandlerName(), new SentinelRequestHandler<String>(new FetchActiveRuleCommandHandler()));
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.VERSION.getHandlerName(), new SentinelRequestHandler<String>(new VersionCommandHandler()));
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.GET_SWITCH.getHandlerName(), new SentinelRequestHandler<String>(new OnOffGetCommandHandler()));
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.SET_SWITCH.getHandlerName(), new SentinelRequestHandler<String>(new OnOffSetCommandHandler()));
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.SET_CLUSTER_MODE.getHandlerName(), new SentinelRequestHandler<String>(new ModifyClusterModeCommandHandler()));
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.GET_CLUSTER_MODE.getHandlerName(), new SentinelRequestHandler<String>(new FetchClusterModeCommandHandler()));
        agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.CHECK_FALLBACK_BEHAVIOR.getHandlerName(), new SentinelRequestHandler<String>(new FallbackBehaviorCheckCommandHandler()));
        if (AgwComponentType.PRIVATE_CLOUD.getType() == SentinelSdkInitServiceManager.getMode()) {
            agwComponent.getTransportService().registerHandler(ServiceConstants.Sentinel.EXECUTE_SHELL_COMMAND.getHandlerName(), new SentinelRequestHandler<String>(new ExecuteShellCommandHandler()));
        }
    }

    private void initHeartbeatTask() {
        int intervalMs;
        int ahasHbIntervalMs = agwComponent.getClientInfoService().getHeartbeatRate() * 1000;
        int n = intervalMs = ahasHbIntervalMs > 0 ? ahasHbIntervalMs : 8000;
        if (AgwComponentManager.isInner() && agwComponent.getClientInfoService().getUserId() == null) {
            return;
        }
        hbScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSentinelSdkService.this.sendHeartbeat();
                }
                catch (Throwable var2) {
                    RecordLog.warn("[HeartbeatSender] Send heartbeat error", var2);
                }
            }
        }, 3000L, intervalMs, TimeUnit.MILLISECONDS);
        RecordLog.info("AHAS Sentinel heartbeat task started, interval={}ms", intervalMs);
    }

    public boolean sendHeartbeat() throws Exception {
        if (!ahasInitSuccess.get() || agwComponent.getClientInfoService().getSentinalDisable() == 1) {
            return false;
        }
        if (AgwComponentManager.isInner() && agwComponent.getClientInfoService().getUserId() == null) {
            return false;
        }
        Response<String> mapResponse = agwComponent.getHeartbeatService().sendHeartbeat();
        if (!mapResponse.isSuccess()) {
            throw new RuntimeException(mapResponse.toString());
        }
        return mapResponse.isSuccess();
    }
}

