/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.AgwRequestHandler;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Request;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Response;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.log.RecordLog;

public class SentinelRequestHandler<R>
extends AgwRequestHandler<R> {
    private CommandHandler commandHandler;

    public SentinelRequestHandler(CommandHandler<R> commandHandler) {
        this.commandHandler = commandHandler;
    }

    @Override
    public Response<R> handle(Request request) {
        if (this.commandHandler == null) {
            return Response.ofFailure(Response.Code.NOT_FOUND, "Cannot find command handler");
        }
        return this.convertResponse(this.commandHandler.handle(this.convertRequest(request)));
    }

    private CommandRequest convertRequest(Request request) {
        CommandRequest commandRequest = new CommandRequest();
        if (request == null) {
            return commandRequest;
        }
        commandRequest.getMetadata().putAll(request.getHeaders());
        commandRequest.getParameters().putAll(request.getParams());
        return commandRequest;
    }

    private Response<R> convertResponse(CommandResponse<R> response) {
        if (response == null) {
            return Response.ofFailure(Response.Code.TIMEOUT, "response is null");
        }
        if (response.isSuccess()) {
            return Response.ofSuccess(response.getResult());
        }
        return Response.ofFailure(Response.Code.SERVER_ERROR, response.getException().getMessage());
    }

    @Override
    public void logHandleException(Request request, Exception exception) {
        RecordLog.info("logHandleException, " + request, exception);
    }
}

