/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.acm;

import com.alibaba.csp.ahas.sentinel.AhasSentinelConstants;
import com.alibaba.csp.ahas.sentinel.acm.SentinelSdkInitService;
import com.alibaba.csp.ahas.sentinel.init.AhasSentinelInitFunc;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.AppNameUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.support.LogLog;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.SpiLoader;
import java.util.List;

public abstract class AbstractSentinelSdkInitService
implements SentinelSdkInitService {
    private static final String SENTINEL_ENV_CLASS = "com.alibaba.csp.sentinel.Env";
    protected final ClientInfoService clientInfoService;

    public AbstractSentinelSdkInitService(ClientInfoService clientInfoService) {
        this.clientInfoService = clientInfoService;
    }

    @Override
    public void init(String sdkVersion) throws Exception {
        LogLog.setQuietMode(true);
        this.initBySpi();
        this.init0(sdkVersion);
        this.initSentinel();
    }

    private void initBySpi() {
        try {
            List<AhasSentinelInitFunc> initFuncList = SpiLoader.loadInstanceListSorted(AhasSentinelInitFunc.class);
            for (AhasSentinelInitFunc initFunc : initFuncList) {
                initFunc.init(this.clientInfoService);
            }
        }
        catch (Throwable t) {
            RecordLog.warn("Failed to initialize by AhasSentinelInitFunc SPI", t);
        }
    }

    protected abstract void init0(String var1) throws Exception;

    private void initSentinel() throws Exception {
        try {
            this.getClass().getClassLoader().loadClass(SENTINEL_ENV_CLASS);
        }
        catch (ClassNotFoundException e) {
            RecordLog.warn("[DefaultSentinelSdkService][ERROR] com.alibaba.csp.sentinel.Env not found!", e);
        }
    }

    protected boolean isGatewayAppType() {
        return AhasSentinelConstants.GATEWAY_APP_TYPES.contains(AppNameUtil.getAppType());
    }
}

