/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.acm;

import com.alibaba.csp.ahas.sentinel.acm.AbstractSentinelSdkInitService;
import com.alibaba.csp.ahas.sentinel.datasource.parser.ApplicationClusterInfoParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.ParamFlowRuleParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.fallback.BlockFallbackConfigListParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.gateway.GatewayApiDefinitionParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.gateway.GatewayFlowRuleParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelAdapterSettingParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelAdaptiveFlowSettingParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelGeneralSettingParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DiamondDataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.SentinelAcmConstants;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.DegradeRuleConfigParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.FlowRuleConfigParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.ManualDegradeRuleListParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.RetryRuleListParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.SystemRuleConfigParser;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.GatewayApiDefinitionManager;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingEntity;
import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingManager;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.machine.MachineGroupEntity;
import com.alibaba.csp.sentinel.machine.MachineGroupManager;
import com.alibaba.csp.sentinel.retry.RetryRule;
import com.alibaba.csp.sentinel.retry.RetryRuleManager;
import com.alibaba.csp.sentinel.setting.adapter.AdapterSettingManager;
import com.alibaba.csp.sentinel.setting.adapter.SentinelAdapterSettingEntity;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfigManager;
import com.alibaba.csp.sentinel.setting.general.GeneralSettingManager;
import com.alibaba.csp.sentinel.setting.general.SentinelGeneralSettingEntity;
import com.alibaba.csp.sentinel.slots.block.degrade.DefaultCircuitBreakerRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.ManualDegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.ManualDegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import java.util.List;
import java.util.Set;

public class ApsaraSdkInitService
extends AbstractSentinelSdkInitService {
    public ApsaraSdkInitService(ClientInfoService clientInfoService) {
        super(clientInfoService);
    }

    @Override
    public void init0(String sdkVersion) throws Exception {
        this.initAcmDataSource();
    }

    private void initAcmDataSource() throws DiamondException {
        String namespace = this.clientInfoService.getNamespace();
        String userId = this.clientInfoService.getUserId();
        String consoleTenantId = this.clientInfoService.getTid();
        String appName = this.clientInfoService.getAppName();
        this.initSettingDs(consoleTenantId, userId, namespace, appName);
        this.initBlockFallbackDs(consoleTenantId, userId, namespace, appName);
        this.initApplicationClusterInfoDs(consoleTenantId, userId, namespace, appName);
        this.initClientRuleDs(consoleTenantId, userId, namespace, appName);
        if (this.isGatewayAppType()) {
            this.initApiGatewayDs(consoleTenantId, userId, namespace, appName);
        }
    }

    private void initClientRuleDs(String consoleTenantId, String userId, String namespace, String appName) throws DiamondException {
        String flowDataId = SentinelAcmConstants.formFlowRuleDataId(userId, namespace, appName);
        FlowRuleManager.register2Property(new DiamondDataSource<List<FlowRule>>(consoleTenantId, flowDataId, "ahas-sentinel", new FlowRuleConfigParser()).getProperty());
        String degradeDataId = SentinelAcmConstants.formDegradeRuleDataId(userId, namespace, appName);
        DegradeRuleManager.register2Property(new DiamondDataSource<List<DegradeRule>>(consoleTenantId, degradeDataId, "ahas-sentinel", new DegradeRuleConfigParser()).getProperty());
        String defaultCbRuleDataId = SentinelAcmConstants.formDefaultCircuitBreakerRuleDataId(userId, namespace, appName);
        DefaultCircuitBreakerRuleManager.register2Property(new DiamondDataSource<List<DegradeRule>>(consoleTenantId, defaultCbRuleDataId, "ahas-sentinel", new DegradeRuleConfigParser()).getProperty());
        String systemDataId = SentinelAcmConstants.formSystemRuleDataId(userId, namespace, appName);
        SystemRuleManager.register2Property(new DiamondDataSource<List<SystemRule>>(consoleTenantId, systemDataId, "ahas-sentinel", new SystemRuleConfigParser()).getProperty());
        String paramFlowDataId = SentinelAcmConstants.formParamFlowRuleDataId(userId, namespace, appName);
        ParamFlowRuleManager.register2Property(new DiamondDataSource<List<ParamFlowRule>>(consoleTenantId, paramFlowDataId, "ahas-sentinel", new ParamFlowRuleParser()).getProperty());
        String retryRuleDataId = SentinelAcmConstants.formRetryRuleDataId(userId, namespace, appName);
        RetryRuleManager.getInstance().register2Property(new DiamondDataSource<List<RetryRule>>(consoleTenantId, retryRuleDataId, "ahas-sentinel", new RetryRuleListParser()).getProperty());
        String mdrDataId = SentinelAcmConstants.formManualDegradeRuleDataId(userId, namespace, appName);
        ManualDegradeRuleManager.getInstance().register2Property(new DiamondDataSource<List<ManualDegradeRule>>(consoleTenantId, mdrDataId, "ahas-sentinel", new ManualDegradeRuleListParser()).getProperty());
        String log = String.format("Diamond, flowDataId: %s, degradeDataId: %s, groupId: %s, namespace: %s", flowDataId, degradeDataId, "ahas-sentinel", namespace);
        RecordLog.info(log, new Object[0]);
    }

    private void initApiGatewayDs(String consoleTenantId, String userId, String acmNamespace, String appName) throws DiamondException {
        RecordLog.info("[SentinelDiamondDsService] Initializing data source for API gateway integration", new Object[0]);
        String gatewayFlowRuleDataId = SentinelAcmConstants.formGatewayFlowRuleDataId(userId, acmNamespace, appName);
        DiamondDataSource<Set<GatewayFlowRule>> gatewayFlowRuleDs = new DiamondDataSource<Set<GatewayFlowRule>>(consoleTenantId, gatewayFlowRuleDataId, "ahas-sentinel", new GatewayFlowRuleParser());
        GatewayRuleManager.register2Property(gatewayFlowRuleDs.getProperty());
        String gatewayApiDefDataId = SentinelAcmConstants.formGatewayApiDefinitionDataId(userId, acmNamespace, appName);
        DiamondDataSource<Set<ApiDefinition>> gatewayApiDefinitionDs = new DiamondDataSource<Set<ApiDefinition>>(consoleTenantId, gatewayApiDefDataId, "ahas-sentinel", new GatewayApiDefinitionParser());
        GatewayApiDefinitionManager.register2Property(gatewayApiDefinitionDs.getProperty());
    }

    private void initSettingDs(String consoleTenantId, String userId, String acmNamespace, String appName) throws DiamondException {
        String gsDataId = SentinelAcmConstants.formGeneralSettingDataId(userId, acmNamespace, appName);
        DiamondDataSource<SentinelGeneralSettingEntity> generalSettingDs = new DiamondDataSource<SentinelGeneralSettingEntity>(consoleTenantId, gsDataId, "ahas-sentinel", new SentinelGeneralSettingParser());
        GeneralSettingManager.register2Property(generalSettingDs.getProperty());
        String asDataId = SentinelAcmConstants.formAdapterSettingDataId(userId, acmNamespace, appName);
        DiamondDataSource<SentinelAdapterSettingEntity> adapterSettingDs = new DiamondDataSource<SentinelAdapterSettingEntity>(consoleTenantId, asDataId, "ahas-sentinel", new SentinelAdapterSettingParser());
        AdapterSettingManager.register2Property(adapterSettingDs.getProperty());
        String afSettingDataId = SentinelAcmConstants.formAdaptiveFlowSettingDataId(userId, acmNamespace, appName);
        DiamondDataSource<AdaptiveFlowSettingEntity> adaptiveFlowSettingDs = new DiamondDataSource<AdaptiveFlowSettingEntity>(consoleTenantId, afSettingDataId, "ahas-sentinel", new SentinelAdaptiveFlowSettingParser());
        AdaptiveFlowSettingManager.register2Property(adaptiveFlowSettingDs.getProperty());
    }

    private void initBlockFallbackDs(String tenantId, String userId, String namespace, String appName) throws DiamondException {
        String bfcDataId = SentinelAcmConstants.formBlockFallbackConfigDataId(userId, namespace, appName);
        BlockFallbackConfigManager.getInstance().register2Property(new DiamondDataSource<List<BlockFallbackConfig<Object>>>(tenantId, bfcDataId, "ahas-sentinel", new BlockFallbackConfigListParser()).getProperty());
    }

    private void initApplicationClusterInfoDs(String tenantId, String userId, String namespace, String appName) throws DiamondException {
        String machineGroupDataId = SentinelAcmConstants.formMachineGroupDataId(userId, namespace, appName);
        MachineGroupManager.register2Property(new DiamondDataSource<MachineGroupEntity>(tenantId, machineGroupDataId, "ahas-sentinel", new ApplicationClusterInfoParser()).getProperty());
    }
}

