/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.acm;

import com.alibaba.csp.ahas.sentinel.acm.AbstractSentinelSdkInitService;
import com.alibaba.csp.ahas.sentinel.acm.SimpleDecryptor;
import com.alibaba.csp.ahas.sentinel.datasource.parser.ApplicationClusterInfoParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.ParamFlowRuleParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.WebFlowRuleParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterAssignStateParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterClientAssignConfigParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterClientCommonConfigParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.fallback.BlockFallbackConfigListParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.gateway.GatewayApiDefinitionParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.gateway.GatewayFlowRuleParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelAdapterSettingParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelAdaptiveFlowSettingParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelGeneralSettingParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DecryptAcmWhiteDataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.SentinelAcmConstants;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.DegradeRuleConfigParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.FlowRuleConfigParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.ManualDegradeRuleListParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.RetryRuleListParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.SystemRuleConfigParser;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.auth.api.AuthUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.GatewayApiDefinitionManager;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingEntity;
import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingManager;
import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.auth.ClientAuthConfigRegistry;
import com.alibaba.csp.sentinel.cluster.client.auth.ClientCredentialSupplier;
import com.alibaba.csp.sentinel.cluster.client.auth.ssl.CertStorage;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.cluster.registry.ConfigSupplierRegistry;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.machine.MachineGroupEntity;
import com.alibaba.csp.sentinel.machine.MachineGroupManager;
import com.alibaba.csp.sentinel.retry.RetryRule;
import com.alibaba.csp.sentinel.retry.RetryRuleManager;
import com.alibaba.csp.sentinel.setting.adapter.AdapterSettingManager;
import com.alibaba.csp.sentinel.setting.adapter.SentinelAdapterSettingEntity;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfigManager;
import com.alibaba.csp.sentinel.setting.general.GeneralSettingManager;
import com.alibaba.csp.sentinel.setting.general.SentinelGeneralSettingEntity;
import com.alibaba.csp.sentinel.slots.block.degrade.DefaultCircuitBreakerRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.ManualDegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.ManualDegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.util.function.Supplier;
import com.alibaba.csp.sentinel.web.adapter.common.rule.WebFlowRule;
import com.alibaba.csp.sentinel.web.adapter.common.rule.WebFlowRuleManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultSdkInitService
extends AbstractSentinelSdkInitService {
    private final SimpleDecryptor decryptor = new SimpleDecryptor();

    public DefaultSdkInitService(ClientInfoService clientInfoService) {
        super(clientInfoService);
    }

    @Override
    protected void init0(String sdkVersion) throws Exception {
        this.initClusterFlow(sdkVersion);
        this.initAcmDataSource();
    }

    private void initClusterFlow(final String sdkVersion) {
        final String userId = this.clientInfoService.getUserId();
        final String ahasNamespace = this.clientInfoService.getNamespace();
        ConfigSupplierRegistry.setNamespaceSupplier(new Supplier<String>(){

            @Override
            public String get() {
                return userId + "|" + ahasNamespace + "|" + DefaultSdkInitService.this.clientInfoService.getAppName();
            }
        });
        ClientAuthConfigRegistry.setClientCredentialSupplier(new ClientCredentialSupplier(){

            @Override
            public Map<String, String> getCredentials() {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("uid", userId);
                map.put("ahasNs", ahasNamespace);
                map.put("sk", AuthUtil.getSecretKey());
                map.put("instanceId", DefaultSdkInitService.this.clientInfoService.getAid());
                map.put("clientType", "JAVA_SDK");
                map.put("clientVersion", sdkVersion);
                map.put("cpbId", String.valueOf(1));
                return map;
            }
        });
        CertStorage.createOrUpdateClientCert(this.clientInfoService.getRegionId(), this.clientInfoService.getAhasEnv());
    }

    private void initAcmDataSource() throws DiamondException {
        String currentEndPoint = this.clientInfoService.getAcmEndpoint();
        RecordLog.info("[SentinelAcmDataSourceService] ACM endpoint: " + currentEndPoint, new Object[0]);
        System.setProperty("ahas.address.server.domain", currentEndPoint);
        String namespace = this.clientInfoService.getNamespace();
        String userId = this.clientInfoService.getUserId();
        String consoleTenantId = this.clientInfoService.getTid();
        String appName = this.clientInfoService.getAppName();
        this.initSettingDs(consoleTenantId, userId, namespace, appName);
        this.initBlockFallbackDs(consoleTenantId, userId, namespace, appName);
        this.initApplicationClusterInfoDs(consoleTenantId, userId, namespace, appName);
        this.initClientRuleDs(consoleTenantId, userId, namespace, appName);
        this.initSentinelClusterDs(consoleTenantId, userId, namespace, appName);
        if (this.isGatewayAppType()) {
            this.initApiGatewayDs(consoleTenantId, userId, namespace, appName);
        }
    }

    private void initClientRuleDs(String tenantId, String userId, String namespace, String appName) throws DiamondException {
        String flowDataId = SentinelAcmConstants.formFlowRuleDataId(userId, namespace, appName);
        FlowRuleManager.register2Property(new DecryptAcmWhiteDataSource<List<FlowRule>>(tenantId, flowDataId, "ahas-sentinel", new FlowRuleConfigParser(), this.decryptor).getProperty());
        String degradeDataId = SentinelAcmConstants.formDegradeRuleDataId(userId, namespace, appName);
        DegradeRuleManager.register2Property(new DecryptAcmWhiteDataSource<List<DegradeRule>>(tenantId, degradeDataId, "ahas-sentinel", new DegradeRuleConfigParser(), this.decryptor).getProperty());
        String defaultCbRuleDataId = SentinelAcmConstants.formDefaultCircuitBreakerRuleDataId(userId, namespace, appName);
        DefaultCircuitBreakerRuleManager.register2Property(new DecryptAcmWhiteDataSource<List<DegradeRule>>(tenantId, defaultCbRuleDataId, "ahas-sentinel", new DegradeRuleConfigParser(), this.decryptor).getProperty());
        String systemDataId = SentinelAcmConstants.formSystemRuleDataId(userId, namespace, appName);
        SystemRuleManager.register2Property(new DecryptAcmWhiteDataSource<List<SystemRule>>(tenantId, systemDataId, "ahas-sentinel", new SystemRuleConfigParser(), this.decryptor).getProperty());
        String paramFlowDataId = SentinelAcmConstants.formParamFlowRuleDataId(userId, namespace, appName);
        ParamFlowRuleManager.register2Property(new DecryptAcmWhiteDataSource<List<ParamFlowRule>>(tenantId, paramFlowDataId, "ahas-sentinel", new ParamFlowRuleParser(), this.decryptor).getProperty());
        String retryRuleDataId = SentinelAcmConstants.formRetryRuleDataId(userId, namespace, appName);
        RetryRuleManager.getInstance().register2Property(new DecryptAcmWhiteDataSource<List<RetryRule>>(tenantId, retryRuleDataId, "ahas-sentinel", new RetryRuleListParser(), this.decryptor).getProperty());
        String mdrDataId = SentinelAcmConstants.formManualDegradeRuleDataId(userId, namespace, appName);
        ManualDegradeRuleManager.getInstance().register2Property(new DecryptAcmWhiteDataSource<List<ManualDegradeRule>>(tenantId, mdrDataId, "ahas-sentinel", new ManualDegradeRuleListParser(), this.decryptor).getProperty());
        String webFlowRuleDataId = SentinelAcmConstants.formWebFlowRuleDataId(userId, namespace, appName);
        DecryptAcmWhiteDataSource<Set<WebFlowRule>> webFlowRuleDs = new DecryptAcmWhiteDataSource<Set<WebFlowRule>>(tenantId, webFlowRuleDataId, "ahas-sentinel", new WebFlowRuleParser(), this.decryptor);
        WebFlowRuleManager.register2Property(webFlowRuleDs.getProperty());
        String log = String.format("ACM data-source initialized, flowDataId: %s, degradeDataId: %s, group: %s, tid: %s", flowDataId, degradeDataId, "ahas-sentinel", tenantId);
        RecordLog.info(log, new Object[0]);
    }

    private void initSentinelClusterDs(String tenantId, String userId, String acmNamespace, String appName) throws DiamondException {
        String clusterMapDataId = SentinelAcmConstants.formClusterAssignMapDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<ClusterClientAssignConfig> clientAssignDs = new DecryptAcmWhiteDataSource<ClusterClientAssignConfig>(tenantId, clusterMapDataId, "ahas-sentinel", new ClusterClientAssignConfigParser(), this.decryptor);
        ClusterClientConfigManager.registerServerAssignProperty(clientAssignDs.getProperty());
        String clientConfigDataId = SentinelAcmConstants.formClusterClientConfigDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<ClusterClientConfig> clientConfigDs = new DecryptAcmWhiteDataSource<ClusterClientConfig>(tenantId, clientConfigDataId, "ahas-sentinel", new ClusterClientCommonConfigParser(), this.decryptor);
        ClusterClientConfigManager.registerClientConfigProperty(clientConfigDs.getProperty());
        DecryptAcmWhiteDataSource<Integer> clusterStateDs = new DecryptAcmWhiteDataSource<Integer>(tenantId, clusterMapDataId, "ahas-sentinel", new ClusterAssignStateParser(), this.decryptor);
        ClusterStateManager.registerProperty(clusterStateDs.getProperty());
    }

    private void initApiGatewayDs(String tenantId, String userId, String acmNamespace, String appName) throws DiamondException {
        RecordLog.info("[SentinelAcmDsService] Initializing data source for API gateway integration", new Object[0]);
        String gatewayFlowRuleDataId = SentinelAcmConstants.formGatewayFlowRuleDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<Set<GatewayFlowRule>> gatewayFlowRuleDs = new DecryptAcmWhiteDataSource<Set<GatewayFlowRule>>(tenantId, gatewayFlowRuleDataId, "ahas-sentinel", new GatewayFlowRuleParser(), this.decryptor);
        GatewayRuleManager.register2Property(gatewayFlowRuleDs.getProperty());
        String gatewayApiDefDataId = SentinelAcmConstants.formGatewayApiDefinitionDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<Set<ApiDefinition>> gatewayApiDefinitionDs = new DecryptAcmWhiteDataSource<Set<ApiDefinition>>(tenantId, gatewayApiDefDataId, "ahas-sentinel", new GatewayApiDefinitionParser(), this.decryptor);
        GatewayApiDefinitionManager.register2Property(gatewayApiDefinitionDs.getProperty());
    }

    private void initSettingDs(String tenantId, String userId, String acmNamespace, String appName) throws DiamondException {
        String gsDataId = SentinelAcmConstants.formGeneralSettingDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<SentinelGeneralSettingEntity> generalSettingDs = new DecryptAcmWhiteDataSource<SentinelGeneralSettingEntity>(tenantId, gsDataId, "ahas-sentinel", new SentinelGeneralSettingParser(), this.decryptor);
        GeneralSettingManager.register2Property(generalSettingDs.getProperty());
        String asDataId = SentinelAcmConstants.formAdapterSettingDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<SentinelAdapterSettingEntity> adapterSettingDs = new DecryptAcmWhiteDataSource<SentinelAdapterSettingEntity>(tenantId, asDataId, "ahas-sentinel", new SentinelAdapterSettingParser(), this.decryptor);
        AdapterSettingManager.register2Property(adapterSettingDs.getProperty());
        String afSettingDataId = SentinelAcmConstants.formAdaptiveFlowSettingDataId(userId, acmNamespace, appName);
        DecryptAcmWhiteDataSource<AdaptiveFlowSettingEntity> adaptiveFlowSettingDs = new DecryptAcmWhiteDataSource<AdaptiveFlowSettingEntity>(tenantId, afSettingDataId, "ahas-sentinel", new SentinelAdaptiveFlowSettingParser(), this.decryptor);
        AdaptiveFlowSettingManager.register2Property(adaptiveFlowSettingDs.getProperty());
    }

    private void initBlockFallbackDs(String tenantId, String userId, String namespace, String appName) throws DiamondException {
        String bfcDataId = SentinelAcmConstants.formBlockFallbackConfigDataId(userId, namespace, appName);
        BlockFallbackConfigManager.getInstance().register2Property(new DecryptAcmWhiteDataSource<List<BlockFallbackConfig<Object>>>(tenantId, bfcDataId, "ahas-sentinel", new BlockFallbackConfigListParser(), this.decryptor).getProperty());
    }

    private void initApplicationClusterInfoDs(String tenantId, String userId, String namespace, String appName) throws DiamondException {
        String machineGroupDataId = SentinelAcmConstants.formMachineGroupDataId(userId, namespace, appName);
        MachineGroupManager.register2Property(new DecryptAcmWhiteDataSource<MachineGroupEntity>(tenantId, machineGroupDataId, "ahas-sentinel", new ApplicationClusterInfoParser(), this.decryptor).getProperty());
    }
}

