/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.acm;

import com.alibaba.csp.ahas.sentinel.acm.AbstractSentinelSdkInitService;
import com.alibaba.csp.ahas.sentinel.datasource.parser.ApplicationClusterInfoParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterAssignStateParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterClientAssignConfigParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.cluster.ClusterClientCommonConfigParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelAdapterSettingParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelAdaptiveFlowSettingParser;
import com.alibaba.csp.ahas.sentinel.datasource.parser.setting.SentinelGeneralSettingParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.InternalDiamondDataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.parser.RetryRuleListParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.auth.api.AuthUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingEntity;
import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingManager;
import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.auth.ClientAuthConfigRegistry;
import com.alibaba.csp.sentinel.cluster.client.auth.ClientCredentialSupplier;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.cluster.registry.ConfigSupplierRegistry;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.machine.MachineGroupEntity;
import com.alibaba.csp.sentinel.machine.MachineGroupManager;
import com.alibaba.csp.sentinel.node.IntervalProperty;
import com.alibaba.csp.sentinel.node.OccupyTimeoutProperty;
import com.alibaba.csp.sentinel.node.SampleCountProperty;
import com.alibaba.csp.sentinel.retry.RetryRule;
import com.alibaba.csp.sentinel.retry.RetryRuleManager;
import com.alibaba.csp.sentinel.setting.adapter.AdapterSettingManager;
import com.alibaba.csp.sentinel.setting.adapter.SentinelAdapterSettingEntity;
import com.alibaba.csp.sentinel.setting.general.GeneralSettingManager;
import com.alibaba.csp.sentinel.setting.general.SentinelGeneralSettingEntity;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.stresstest.StressingTestModeConfigManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.csp.sentinel.util.function.Supplier;
import com.taobao.csp.sentinel.datasource.LegacyAuthorityRuleParser;
import com.taobao.csp.sentinel.datasource.LegacyDegradeRuleParser;
import com.taobao.csp.sentinel.datasource.LegacyFlowRuleParser;
import com.taobao.csp.sentinel.datasource.LegacyParamFlowRuleParser;
import com.taobao.csp.sentinel.datasource.LegacySystemRuleParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InnerCloudAhasInitService
extends AbstractSentinelSdkInitService {
    private final Converter<String, Integer> jsonIntParser = new Converter<String, Integer>(){

        @Override
        public Integer convert(String s) {
            return JSONObject.parseObject(s, Integer.class);
        }
    };

    public InnerCloudAhasInitService(ClientInfoService clientInfoService) {
        super(clientInfoService);
    }

    @Override
    protected void init0(String sdkVersion) throws Exception {
        RecordLog.info("AHAS Sentinel is running in internal mode", new Object[0]);
        this.initClusterFlow(sdkVersion);
        this.initDiamondDataSource();
    }

    private void initClusterFlow(final String sdkVersion) {
        final String userId = this.clientInfoService.getUserId();
        final String ahasNamespace = this.clientInfoService.getNamespace();
        ConfigSupplierRegistry.setNamespaceSupplier(new Supplier<String>(){

            @Override
            public String get() {
                return userId + "|" + ahasNamespace + "|" + InnerCloudAhasInitService.this.clientInfoService.getAppName();
            }
        });
        ClientAuthConfigRegistry.setClientCredentialSupplier(new ClientCredentialSupplier(){

            @Override
            public Map<String, String> getCredentials() {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("uid", userId);
                map.put("ahasNs", ahasNamespace);
                map.put("sk", AuthUtil.getSecretKey());
                map.put("instanceId", InnerCloudAhasInitService.this.clientInfoService.getAid());
                map.put("clientType", "JAVA_SDK");
                map.put("clientVersion", sdkVersion);
                map.put("cpbId", String.valueOf(1));
                return map;
            }
        });
    }

    private void initDiamondDataSource() {
        try {
            String appName = AppNameUtil.getAppName();
            if (appName == null) {
                RecordLog.warn("[InnerCloudAhasInitService] appName is null, can not init Sentinel data-source", new Object[0]);
                return;
            }
            this.initCommonRuleDs(appName);
            this.initApplicationClusterInfoDs(appName);
            this.initSentinelClusterDs(appName);
            this.initSettingDs(appName);
            this.initInternalSettingDs(appName);
            RecordLog.info("[InnerCloudAhasInitService] Sentinel Diamond data-source successfully initialized", new Object[0]);
        }
        catch (Throwable e) {
            RecordLog.error("[InnerCloudAhasInitService] Failed to initialize Diamond data-source", e);
        }
    }

    private void initCommonRuleDs(String appName) throws DiamondException {
        InternalDiamondDataSource<List<FlowRule>> flowRuleDataSource = new InternalDiamondDataSource<List<FlowRule>>(appName + "-flow", "asp-sentinel", new LegacyFlowRuleParser());
        FlowRuleManager.register2Property(flowRuleDataSource.getProperty());
        InternalDiamondDataSource<List<DegradeRule>> degradeDataSource = new InternalDiamondDataSource<List<DegradeRule>>(appName + "-degrade", "asp-sentinel", new LegacyDegradeRuleParser());
        DegradeRuleManager.register2Property(degradeDataSource.getProperty());
        InternalDiamondDataSource<List<AuthorityRule>> authorityDS = new InternalDiamondDataSource<List<AuthorityRule>>(appName + "-authority", "asp-sentinel", new LegacyAuthorityRuleParser());
        AuthorityRuleManager.register2Property(authorityDS.getProperty());
        InternalDiamondDataSource<List<SystemRule>> systemRuleDataSource = new InternalDiamondDataSource<List<SystemRule>>(appName + "-system", "asp-sentinel", new LegacySystemRuleParser());
        SystemRuleManager.register2Property(systemRuleDataSource.getProperty());
        InternalDiamondDataSource<List<ParamFlowRule>> paramFlowDataSource = new InternalDiamondDataSource<List<ParamFlowRule>>(appName + "-hotparam", "asp-sentinel", new LegacyParamFlowRuleParser("hotitem-", "asp-sentinel"));
        ParamFlowRuleManager.register2Property(paramFlowDataSource.getProperty());
        InternalDiamondDataSource<List<RetryRule>> retryRuleRuleDataSource = new InternalDiamondDataSource<List<RetryRule>>(appName + "-retry-rule", "asp-sentinel", new RetryRuleListParser());
        RetryRuleManager.getInstance().register2Property(retryRuleRuleDataSource.getProperty());
    }

    private void initSentinelClusterDs(String appName) {
        String assignMapDataId = appName + "-cluster-assign-map";
        InternalDiamondDataSource<ClusterClientAssignConfig> clientAssignDs = new InternalDiamondDataSource<ClusterClientAssignConfig>(assignMapDataId, "asp-sentinel", new ClusterClientAssignConfigParser());
        ClusterClientConfigManager.registerServerAssignProperty(clientAssignDs.getProperty());
        String clientConfigDataId = appName + "-cluster-client-config";
        InternalDiamondDataSource<ClusterClientConfig> clientConfigDs = new InternalDiamondDataSource<ClusterClientConfig>(clientConfigDataId, "asp-sentinel", new ClusterClientCommonConfigParser());
        ClusterClientConfigManager.registerClientConfigProperty(clientConfigDs.getProperty());
        InternalDiamondDataSource<Integer> clusterStateDs = new InternalDiamondDataSource<Integer>(assignMapDataId, "asp-sentinel", new ClusterAssignStateParser());
        ClusterStateManager.registerProperty(clusterStateDs.getProperty());
    }

    private void initSettingDs(String appName) {
        String gsDataId = appName + "-general-setting";
        InternalDiamondDataSource<SentinelGeneralSettingEntity> generalSettingDs = new InternalDiamondDataSource<SentinelGeneralSettingEntity>(gsDataId, "asp-sentinel", new SentinelGeneralSettingParser());
        GeneralSettingManager.register2Property(generalSettingDs.getProperty());
        String asDataId = appName + "-adapter-setting";
        InternalDiamondDataSource<SentinelAdapterSettingEntity> adapterSettingDs = new InternalDiamondDataSource<SentinelAdapterSettingEntity>(asDataId, "asp-sentinel", new SentinelAdapterSettingParser());
        AdapterSettingManager.register2Property(adapterSettingDs.getProperty());
        String afSettingDataId = appName + "-adaptive-flow-setting";
        InternalDiamondDataSource<AdaptiveFlowSettingEntity> adaptiveFlowSettingDs = new InternalDiamondDataSource<AdaptiveFlowSettingEntity>(afSettingDataId, "asp-sentinel", new SentinelAdaptiveFlowSettingParser());
        AdaptiveFlowSettingManager.register2Property(adaptiveFlowSettingDs.getProperty());
    }

    private void initInternalSettingDs(String appName) {
        InternalDiamondDataSource<Integer> flowIntervalDs = new InternalDiamondDataSource<Integer>(appName + "-flowinterval", "asp-sentinel", new Converter<String, Integer>(){

            @Override
            public Integer convert(String source) {
                Integer v = JSONObject.parseObject(source, Integer.class);
                if (v != null) {
                    v = v * 1000;
                }
                return v;
            }
        });
        IntervalProperty.register2Property(flowIntervalDs.getProperty());
        InternalDiamondDataSource<Integer> sampleCountDs = new InternalDiamondDataSource<Integer>(appName + "-sample-count", "asp-sentinel", this.jsonIntParser);
        SampleCountProperty.register2Property(sampleCountDs.getProperty());
        InternalDiamondDataSource<Boolean> stressTestModeConfigDs = new InternalDiamondDataSource<Boolean>(appName + "-stressing-test", "asp-sentinel", new Converter<String, Boolean>(){

            @Override
            public Boolean convert(String s) {
                return JSONObject.parseObject(s, Boolean.class);
            }
        });
        StressingTestModeConfigManager.register2Property(stressTestModeConfigDs.getProperty());
        InternalDiamondDataSource<Integer> priorityTimeoutConfigDs = new InternalDiamondDataSource<Integer>(appName + "-priority-timeout", "asp-sentinel", this.jsonIntParser);
        OccupyTimeoutProperty.register2Property(priorityTimeoutConfigDs.getProperty());
    }

    private void initApplicationClusterInfoDs(String appName) {
        String machineGroupDataId = appName + "-application-cluster-info";
        InternalDiamondDataSource<MachineGroupEntity> clusterInfoDs = new InternalDiamondDataSource<MachineGroupEntity>(machineGroupDataId, "asp-sentinel", new ApplicationClusterInfoParser());
        MachineGroupManager.register2Property(clusterInfoDs.getProperty());
    }
}

