/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.acm;

import com.alibaba.csp.ahas.sentinel.acm.ApsaraSdkInitService;
import com.alibaba.csp.ahas.sentinel.acm.DefaultSdkInitService;
import com.alibaba.csp.ahas.sentinel.acm.InnerCloudAhasInitService;
import com.alibaba.csp.ahas.sentinel.acm.SentinelSdkInitService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.component.AgwComponentType;
import com.alibaba.csp.sentinel.util.StringUtil;

public class SentinelSdkInitServiceManager {
    public static int getMode() {
        int defaultValue = AgwComponentType.PUBLIC_CLOUD.getType();
        try {
            String agwTypeStr = System.getProperty("ahas.agw.type");
            if (StringUtil.isEmpty(agwTypeStr)) {
                return defaultValue;
            }
            return Integer.parseInt(agwTypeStr);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static SentinelSdkInitService getInitService(ClientInfoService clientInfoService) {
        int mode = SentinelSdkInitServiceManager.getMode();
        if (AgwComponentType.PRIVATE_CLOUD.getType() == mode) {
            return new ApsaraSdkInitService(clientInfoService);
        }
        if (AgwComponentType.INNER_CLOUD.getType() == mode) {
            return new InnerCloudAhasInitService(clientInfoService);
        }
        return new DefaultSdkInitService(clientInfoService);
    }
}

