/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.datasource.parser.cluster;

import com.alibaba.csp.ahas.sentinel.cluster.entity.ClusterGroupEntity;
import com.alibaba.csp.ahas.sentinel.util.MachineUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.datasource.Converter;
import java.util.List;
import java.util.Set;

public class ClusterClientAssignConfigParser
implements Converter<String, ClusterClientAssignConfig> {
    @Override
    public ClusterClientAssignConfig convert(String source) {
        if (source == null) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        List<ClusterGroupEntity> groupList = JSON.parseObject(data, new TypeReference<List<ClusterGroupEntity>>(){}, new Feature[0]);
        if (groupList == null || groupList.isEmpty()) {
            return null;
        }
        return this.extractClientAssignment(groupList);
    }

    private ClusterClientAssignConfig extractClientAssignment(List<ClusterGroupEntity> groupList) {
        for (ClusterGroupEntity group : groupList) {
            Set<String> clientSet = group.getClientSet();
            String self = MachineUtils.getCurrentProcessConfigurationId();
            if (!clientSet.contains("all") && !clientSet.contains(self)) continue;
            String ip = group.getIp();
            Integer port = group.getPort();
            return new ClusterClientAssignConfig(ip, port);
        }
        return null;
    }
}

