/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.datasource.parser.fallback;

import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DataAcmFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONArray;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConstants;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class BlockFallbackConfigListParser
implements Converter<String, List<BlockFallbackConfig<Object>>> {
    @Override
    public List<BlockFallbackConfig<Object>> convert(String source) {
        if (StringUtil.isBlank(source)) {
            return null;
        }
        String data = new DataAcmFormat(source).getData();
        if (StringUtil.isBlank(data)) {
            return null;
        }
        JSONArray arr = JSON.parseArray(data);
        ArrayList<BlockFallbackConfig<Object>> list = new ArrayList<BlockFallbackConfig<Object>>();
        if (arr.isEmpty()) {
            return list;
        }
        for (Object obj : arr) {
            JSONObject item;
            Integer targetResourceType;
            if (!(obj instanceof JSONObject) || (targetResourceType = (item = (JSONObject)obj).getInteger("targetResourceType")) == null || !BlockFallbackConstants.isResourceTypeSupported(targetResourceType)) continue;
            if (targetResourceType == 1) {
                list.add((BlockFallbackConfig<Object>)item.toJavaObject(new TypeReference<BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior>>(){}));
                continue;
            }
            if (targetResourceType != 2) continue;
            list.add((BlockFallbackConfig<Object>)item.toJavaObject(new TypeReference<BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior>>(){}));
        }
        return list;
    }
}

