/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.util;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public final class FileConfigUtil {
    public static final String CLASSPATH_FILE_FLAG = "classpath:";

    public static Properties loadProperties(String fileName) {
        if (StringUtil.isNotBlank(fileName)) {
            if (fileName.startsWith(CLASSPATH_FILE_FLAG)) {
                return FileConfigUtil.loadPropertiesFromClasspathFile(fileName);
            }
            return FileConfigUtil.loadPropertiesFromAbsoluteFile(fileName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties loadPropertiesFromAbsoluteFile(String fileName) {
        Properties properties = null;
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName(SentinelConfig.charset())));
            properties = new Properties();
            properties.load(bufferedReader);
            if (bufferedReader == null) return properties;
            try {
                bufferedReader.close();
                return properties;
            }
            catch (Exception e) {
                RecordLog.warn("Error when loading properties close reader: {}", fileName, e);
            }
            return properties;
            catch (Throwable e) {
                try {
                    e.printStackTrace();
                    if (bufferedReader == null) return properties;
                }
                catch (Throwable throwable) {
                    if (bufferedReader == null) throw throwable;
                    try {
                        bufferedReader.close();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        RecordLog.warn("Error when loading properties close reader: {}", fileName, e2);
                    }
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                    return properties;
                }
                catch (Exception e3) {
                    RecordLog.warn("Error when loading properties close reader: {}", fileName, e3);
                }
                return properties;
            }
        }
        catch (Throwable e) {
            RecordLog.warn("Error when loading properties from: {}", fileName, e);
        }
        return properties;
    }

    private static boolean absolutePathStart(String path) {
        File[] files;
        for (File file : files = File.listRoots()) {
            if (!path.startsWith(file.getPath())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Properties loadPropertiesFromClasspathFile(String fileName) {
        fileName = fileName.substring(CLASSPATH_FILE_FLAG.length()).trim();
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = FileConfigUtil.getClassLoader().getResources(fileName);
            list = new ArrayList();
            while (urls.hasMoreElements()) {
                list.add(urls.nextElement());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (list.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        for (URL url : list) {
            Properties p = new Properties();
            InputStreamReader reader = null;
            reader = new InputStreamReader(url.openStream(), Charset.forName(SentinelConfig.charset()).newDecoder());
            p.load(reader);
            properties.putAll((Map<?, ?>)p);
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (Exception e) {
                RecordLog.warn("Error when loading from classpath close reader: {}", fileName, e);
            }
            continue;
            catch (Throwable e) {
                try {
                    RecordLog.warn("Error when loading properties from: {}", url.toString(), e);
                    e.printStackTrace();
                    if (reader == null) continue;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            RecordLog.warn("Error when loading from classpath close reader: {}", fileName, e2);
                        }
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (Exception e3) {
                    RecordLog.warn("Error when loading from classpath close reader: {}", fileName, e3);
                }
            }
        }
        return properties;
    }

    private static Properties loadPropertiesFromRelativeFile(String fileName) {
        String userDir = System.getProperty("user.dir");
        String realFilePath = FileConfigUtil.addSeparator(userDir) + fileName;
        return FileConfigUtil.loadPropertiesFromAbsoluteFile(realFilePath);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = FileConfigUtil.class.getClassLoader();
        }
        return classLoader;
    }

    public static String addSeparator(String dir) {
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return dir;
    }

    private FileConfigUtil() {
    }
}

