/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.web;

import com.alibaba.csp.ahas.sentinel.web.SentinelWebMvcConfig;
import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.servlet.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.adapter.servlet.callback.UrlCleaner;
import com.alibaba.csp.sentinel.adapter.servlet.callback.WebCallbackManager;
import com.alibaba.csp.sentinel.adapter.servlet.param.HttpServletRequestItemParser;
import com.alibaba.csp.sentinel.adapter.servlet.util.FilterUtil;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.flow.statuscode.StatusCodeMetricManager;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.web.adapter.common.param.WebParamParser;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

public class SentinelWebInterceptor
implements HandlerInterceptor {
    public static final String SENTINEL_ENTRY_ATTR_KEY = "$$sentinel_web_entry";
    public static final String SPRING_WEB_CONTEXT = "sentinel_spring_web_context";
    private final SentinelWebMvcConfig config;
    private final WebParamParser<HttpServletRequest> webParamParser = new WebParamParser<HttpServletRequest>(new HttpServletRequestItemParser());
    private static final String EMPTY_ORIGIN = "";

    public SentinelWebInterceptor() {
        this(new SentinelWebMvcConfig());
    }

    public SentinelWebInterceptor(SentinelWebMvcConfig webMvcConfig) {
        AssertUtil.notNull(webMvcConfig, "webMvcConfig cannot be null");
        this.config = webMvcConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Object pattern = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        String apiResourceName = pattern != null ? (String)pattern : FilterUtil.filterTarget(request);
        UrlCleaner urlCleaner = WebCallbackManager.getUrlCleaner();
        if (urlCleaner != null) {
            apiResourceName = urlCleaner.clean(apiResourceName);
        }
        if (StringUtil.isEmpty(apiResourceName)) {
            return true;
        }
        if (this.config.isHttpMethodSpecify()) {
            apiResourceName = request.getMethod().toUpperCase() + ":" + apiResourceName;
        }
        String origin = this.parseOrigin(request);
        ContextUtil.enter(SPRING_WEB_CONTEXT, origin);
        Entry curEntry = this.getCurrentEntry(request);
        if (curEntry != null) {
            return true;
        }
        Map<String, Object> params = this.webParamParser.parseParameterFor(apiResourceName, request, null);
        try {
            AsyncEntry entry = SphU.asyncEntry(apiResourceName, 1, EntryType.IN, 1, params);
            request.setAttribute(SENTINEL_ENTRY_ATTR_KEY, (Object)entry);
            return true;
        }
        catch (BlockException ex) {
            try {
                WebCallbackManager.getUrlBlockHandler().blocked(request, response, apiResourceName, ex);
                int statusCode = response.getStatus();
                StatusCodeMetricManager.getInstance().recordStatusCode(apiResourceName, statusCode);
            }
            finally {
                ContextUtil.exit();
            }
            return false;
        }
    }

    private Entry getCurrentEntry(HttpServletRequest request) {
        Object e = request.getAttribute(SENTINEL_ENTRY_ATTR_KEY);
        if (e == null) {
            return null;
        }
        return (Entry)e;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Entry entry = this.getCurrentEntry(request);
        if (entry == null) {
            return;
        }
        if (ex != null) {
            Tracer.traceEntry(ex, entry);
        }
        int statusCode = response.getStatus();
        StatusCodeMetricManager.getInstance().recordStatusCode(entry.getResourceWrapper().getName(), statusCode);
        entry.exit();
        ContextUtil.exit();
        request.removeAttribute(SENTINEL_ENTRY_ATTR_KEY);
    }

    private String parseOrigin(HttpServletRequest request) {
        RequestOriginParser originParser = WebCallbackManager.getRequestOriginParser();
        String origin = EMPTY_ORIGIN;
        if (originParser != null && StringUtil.isEmpty(origin = originParser.parseOrigin(request))) {
            return EMPTY_ORIGIN;
        }
        return origin;
    }
}

