/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.AlibabaCloudCredentials;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.ECSMetadataServiceCredentialsFetcher;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.InstanceProfileCredentials;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.exceptions.ClientException;

public class InstanceProfileCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private InstanceProfileCredentials credentials = null;
    public int ecsMetadataServiceFetchCount = 0;
    private ECSMetadataServiceCredentialsFetcher fetcher;
    private static final int MAX_ECS_METADATA_FETCH_RETRY_TIMES = 3;
    private int maxRetryTimes = 3;
    private final String roleName;

    public InstanceProfileCredentialsProvider(String roleName) {
        if (null == roleName) {
            throw new NullPointerException("You must specifiy \u5982\u679c\u5207\u6362\u6210\u8fde\u63a5\u6c60\u4f1a\u597d\u70b9\uff0c\u53c2\u8003 https://lark.alipay.com/pop/iz3d8m/pnxd6h#3%E5%A2%9E%E5%8A%A0apachehttpclient \u8bbe\u7f6e\u4e00\u4e0ba valid role name.");
        }
        this.roleName = roleName;
        this.fetcher = new ECSMetadataServiceCredentialsFetcher();
        this.fetcher.setRoleName(this.roleName);
    }

    public InstanceProfileCredentialsProvider withFetcher(ECSMetadataServiceCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        this.fetcher.setRoleName(this.roleName);
        return this;
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException {
        if (this.credentials == null || this.credentials.isExpired()) {
            ++this.ecsMetadataServiceFetchCount;
            this.credentials = this.fetcher.fetch(this.maxRetryTimes);
        } else if (this.credentials.willSoonExpire() && this.credentials.shouldRefresh()) {
            try {
                ++this.ecsMetadataServiceFetchCount;
                this.credentials = this.fetcher.fetch();
            }
            catch (ClientException e) {
                this.credentials.setLastFailedRefreshTime();
            }
        }
        return this.credentials;
    }
}

