/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    public static Document getDocument(String payload) throws ParserConfigurationException, SAXException, IOException {
        if (payload == null || payload.length() < 1) {
            return null;
        }
        StringReader sr = new StringReader(payload);
        InputSource source = new InputSource(sr);
        return XmlUtils.getDocument(source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(InputSource xml, InputStream xsd) throws ParserConfigurationException, SAXException, IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            if (xsd != null) {
                dbf.setNamespaceAware(true);
            }
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.parse(xml);
            if (xsd != null) {
                XmlUtils.validateXml(doc, xsd);
            }
        }
        finally {
            XmlUtils.closeStream(xml.getByteStream());
        }
        return doc;
    }

    public static Element getRootElementFromString(String payload) throws ParserConfigurationException, SAXException, IOException {
        return XmlUtils.getDocument(payload).getDocumentElement();
    }

    public static List<Element> getChildElements(Element parent, String tagName) {
        if (null == parent) {
            return null;
        }
        NodeList nodes = parent.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getParentNode() != parent) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    public static List<Element> getChildElements(Element parent) {
        if (null == parent) {
            return null;
        }
        NodeList nodes = parent.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateXml(InputStream xml, InputStream xsd) throws SAXException, IOException, ParserConfigurationException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(xml);
            XmlUtils.validateXml(doc, xsd);
        }
        finally {
            XmlUtils.closeStream(xml);
            XmlUtils.closeStream(xsd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateXml(Node root, InputStream xsd) throws SAXException, IOException {
        try {
            StreamSource source = new StreamSource(xsd);
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(source);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(root));
        }
        finally {
            XmlUtils.closeStream(xsd);
        }
    }

    private static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

