/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm;

import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.listener.ConfigChangeListener;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.ManagerListener;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.ArrayList;
import java.util.List;

public class AcmWhiteDataSource<T>
extends AbstractDataSource<String, T> {
    private final String tenantId;
    private final String dataId;
    private final String group;
    private ConfigChangeListener listener;

    public AcmWhiteDataSource(String tenantId, final String dataId, String group, Converter<String, T> parser) throws DiamondException {
        super(parser);
        RecordLog.info("AcmWhiteDataSource created, dataId=" + dataId + ", group=" + group, new Object[0]);
        this.tenantId = tenantId;
        this.dataId = dataId;
        this.group = group;
        try {
            Object value = this.loadConfig();
            this.getProperty().updateValue(value);
        }
        catch (Exception e) {
            RecordLog.warn("AcmWhiteDataSource initial loadConfig error", e);
        }
        this.listener = new ConfigChangeListener(){

            @Override
            public void receiveConfigInfo(String conf) {
                try {
                    RecordLog.info("AcmWhiteDataSource dataId <" + dataId + "> receive conf ->" + conf, new Object[0]);
                    Object newValue = AcmWhiteDataSource.this.loadConfig(conf);
                    AcmWhiteDataSource.this.getProperty().updateValue(newValue);
                }
                catch (Exception e) {
                    RecordLog.warn("AcmWhiteDataSource parse entity error, dataId: " + dataId, e);
                }
            }
        };
        DiamondEnvRepo.getDefaultEnv().addListeners(tenantId, dataId, group, (List<? extends ManagerListener>)new ArrayList<ConfigChangeListener>(){
            {
                this.add(AcmWhiteDataSource.this.listener);
            }
        });
    }

    @Override
    public String readSource() throws Exception {
        String conf = DiamondEnvRepo.getDefaultEnv().getConfig(this.tenantId, this.dataId, this.group, 5000L);
        RecordLog.info("AcmWhiteDataSource dataId <" + this.dataId + "> read conf ->" + conf, new Object[0]);
        return conf;
    }

    @Override
    public void close() throws Exception {
    }
}

