/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm;

import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DiamondSharedThreadPool;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.ManagerListener;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.ManagerListenerAdapter;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Arrays;
import java.util.concurrent.Executor;

public class DiamondDataSource<T>
extends AbstractDataSource<String, T> {
    private final String tenantId;
    private final String dataId;
    private final String groupId;
    private ManagerListener diamondListener;

    public DiamondDataSource(String tenantId, final String dataId, String group, Converter<String, T> configParser) throws DiamondException {
        super(configParser);
        this.tenantId = tenantId;
        this.dataId = dataId;
        this.groupId = group;
        try {
            Object value = this.loadConfig();
            if (value == null) {
                RecordLog.warn("[DiamondDataSource] Ignore null value", new Object[0]);
            } else {
                this.getProperty().updateValue(value);
            }
        }
        catch (Exception e) {
            RecordLog.warn("[DiamondDataSource] Failed to load initial config", e);
        }
        this.diamondListener = new ManagerListenerAdapter(){

            @Override
            public void receiveConfigInfo(String conf) {
                try {
                    if (StringUtil.isBlank(conf)) {
                        RecordLog.info("[DiamondDataSource] Empty value will be ignored, dataId: " + dataId, new Object[0]);
                        return;
                    }
                    RecordLog.info("[DiamondDataSource] Data received for dataId " + dataId + ": " + conf, new Object[0]);
                    Object newValue = DiamondDataSource.this.loadConfig(conf);
                    DiamondDataSource.this.getProperty().updateValue(newValue);
                }
                catch (Exception e) {
                    RecordLog.warn("[DiamondDataSource] Failed to parse data value, dataId=" + dataId, e);
                }
            }

            @Override
            public Executor getExecutor() {
                return DiamondSharedThreadPool.INSTANCE;
            }
        };
        DiamondEnvRepo.getDefaultEnv().addListeners(tenantId, dataId, group, Arrays.asList(this.diamondListener));
    }

    @Override
    public String readSource() throws Exception {
        String conf = DiamondEnvRepo.getDefaultEnv().getConfig(this.tenantId, this.dataId, this.groupId, 5000L);
        RecordLog.info("[DiamondDataSource] Read source for dataId <" + this.dataId + ">, content=" + conf, new Object[0]);
        return conf;
    }

    @Override
    public void close() throws Exception {
        if (this.diamondListener != null) {
            DiamondEnvRepo.getDefaultEnv().removeListener(this.tenantId, this.dataId, this.groupId, this.diamondListener);
        }
    }
}

