/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm;

import com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm.DiamondSharedThreadPool;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.Diamond;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.ManagerListener;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.ManagerListenerAdapter;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.concurrent.Executor;

public class InternalDiamondDataSource<T>
extends AbstractDataSource<String, T> {
    private final String dataId;
    private final String group;
    private final ManagerListener diamondListener;

    public InternalDiamondDataSource(final String dataId, String group, Converter<String, T> configParser) {
        super(configParser);
        this.dataId = dataId;
        this.group = group;
        try {
            Object value = this.loadConfig();
            if (value == null) {
                RecordLog.info("[DiamondDataSource] ignore null initial value, dataId=" + dataId, new Object[0]);
            } else {
                this.getProperty().updateValue(value);
            }
        }
        catch (Exception e) {
            RecordLog.warn("Failed to load initial config for dataId: " + dataId, e);
        }
        this.diamondListener = new ManagerListenerAdapter(){

            @Override
            public void receiveConfigInfo(String conf) {
                try {
                    if (conf == null) {
                        RecordLog.warn("[DiamondDataSource] null data received for dataId " + dataId, new Object[0]);
                        InternalDiamondDataSource.this.getProperty().updateValue(null);
                        return;
                    }
                    RecordLog.info("[DiamondDataSource] Data received for dataId " + dataId + ": " + conf, new Object[0]);
                    Object newValue = InternalDiamondDataSource.this.loadConfig(conf);
                    InternalDiamondDataSource.this.getProperty().updateValue(newValue);
                }
                catch (Exception e) {
                    RecordLog.warn("[DiamondDataSource] Failed to parse data for dataId " + dataId, e);
                }
            }

            @Override
            public Executor getExecutor() {
                return DiamondSharedThreadPool.INSTANCE;
            }
        };
        Diamond.addListener(dataId, group, this.diamondListener);
    }

    @Override
    public String readSource() throws Exception {
        String conf = Diamond.getConfig(this.dataId, this.group, 5000L);
        RecordLog.info("[DiamondDataSource] Read source for dataId <" + this.dataId + ">, content=" + conf, new Object[0]);
        return conf;
    }

    @Override
    public void close() {
        Diamond.removeListener(this.dataId, this.group, this.diamondListener);
    }
}

