/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketCounter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketCounterImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketReservoir;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ExponentiallyDecayingReservoir;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Reservoir;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ReservoirType;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.SlidingTimeWindowReservoir;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.SlidingWindowReservoir;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Snapshot;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.UniformReservoir;
import java.util.concurrent.TimeUnit;

public class HistogramImpl
implements Histogram {
    private final Reservoir reservoir;
    private final BucketCounter count;

    public HistogramImpl(ReservoirType type) {
        this(type, 60, 10, Clock.defaultClock());
    }

    public HistogramImpl(int interval, ReservoirType type) {
        this(type, interval, 10, Clock.defaultClock());
    }

    public HistogramImpl(int interval) {
        this(ReservoirType.EXPONENTIALLY_DECAYING, interval, 10, Clock.defaultClock());
    }

    public HistogramImpl(ReservoirType type, int interval, int numberOfBucket, Clock clock) {
        this.count = new BucketCounterImpl(interval, numberOfBucket, clock);
        switch (type) {
            case EXPONENTIALLY_DECAYING: {
                this.reservoir = new ExponentiallyDecayingReservoir(clock);
                break;
            }
            case SLIDING_TIME_WINDOW: {
                this.reservoir = new SlidingTimeWindowReservoir(interval, TimeUnit.SECONDS);
                break;
            }
            case SLIDING_WINDOW: {
                this.reservoir = new SlidingWindowReservoir(1024);
                break;
            }
            case UNIFORM: {
                this.reservoir = new UniformReservoir(1024);
                break;
            }
            case BUCKET: {
                this.reservoir = new BucketReservoir(interval, numberOfBucket, clock, this.count);
                break;
            }
            default: {
                this.reservoir = new ExponentiallyDecayingReservoir(clock);
            }
        }
    }

    public HistogramImpl(Reservoir reservoir, int interval, int numberOfBucket, Clock clock) {
        this.reservoir = reservoir;
        this.count = new BucketCounterImpl(interval, numberOfBucket, clock);
    }

    @Override
    public void update(int value) {
        this.update((long)value);
    }

    @Override
    public void update(long value) {
        this.count.update();
        this.reservoir.update(value);
    }

    @Override
    public long getCount() {
        return this.count.getCount();
    }

    @Override
    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }

    @Override
    public long lastUpdateTime() {
        return this.count.lastUpdateTime();
    }
}

