/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.HistogramImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Meter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MeterImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Reservoir;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ReservoirType;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Snapshot;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Timer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class TimerImpl
implements Timer {
    private final Meter meter;
    private final Histogram histogram;
    private final Clock clock;

    public TimerImpl() {
        this(ReservoirType.EXPONENTIALLY_DECAYING, Clock.defaultClock(), 60);
    }

    public TimerImpl(int interval) {
        this(ReservoirType.EXPONENTIALLY_DECAYING, Clock.defaultClock(), interval);
    }

    public TimerImpl(int interval, ReservoirType type) {
        this(type, Clock.defaultClock(), interval);
    }

    public TimerImpl(ReservoirType reservoir) {
        this(reservoir, Clock.defaultClock(), 60);
    }

    public TimerImpl(ReservoirType reservoir, Clock clock, int interval) {
        this.meter = new MeterImpl(clock, interval);
        this.clock = clock;
        this.histogram = new HistogramImpl(reservoir, interval, 10, clock);
    }

    public TimerImpl(Reservoir reservoir, Clock clock, int interval) {
        this.meter = new MeterImpl(clock, interval);
        this.clock = clock;
        this.histogram = new HistogramImpl(reservoir, interval, 10, clock);
    }

    @Override
    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime);
        }
    }

    @Override
    public Timer.Context time() {
        return new ContextImpl(this, this.clock);
    }

    @Override
    public long getCount() {
        return this.histogram.getCount();
    }

    @Override
    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    @Override
    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    @Override
    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    @Override
    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    @Override
    public Map<Long, Long> getInstantCount() {
        return this.meter.getInstantCount();
    }

    @Override
    public Snapshot getSnapshot() {
        return this.histogram.getSnapshot();
    }

    @Override
    public int getInstantCountInterval() {
        return this.meter.getInstantCountInterval();
    }

    @Override
    public Map<Long, Long> getInstantCount(long startTime) {
        return this.meter.getInstantCount(startTime);
    }

    @Override
    public long lastUpdateTime() {
        return this.meter.lastUpdateTime();
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.histogram.update(duration);
            this.meter.mark();
        }
    }

    public static class ContextImpl
    implements Timer.Context {
        private final Timer timer;
        private final Clock clock;
        private final long startTime;

        private ContextImpl(Timer timer, Clock clock) {
            this.timer = timer;
            this.clock = clock;
            this.startTime = clock.getTick();
        }

        @Override
        public long stop() {
            long elapsed = this.clock.getTick() - this.startTime;
            this.timer.update(elapsed, TimeUnit.NANOSECONDS);
            return elapsed;
        }

        @Override
        public void close() {
            this.stop();
        }
    }
}

