/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketCounter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Compass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Meter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Snapshot;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Timer;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollector;
import java.util.Map;

public class CompactMetricsCollector
extends MetricsCollector {
    CompactMetricsCollector(Map<String, String> globalTags, double rateFactor, double durationFactor, MetricFilter filter) {
        super(globalTags, rateFactor, durationFactor, filter);
    }

    @Override
    public void collect(MetricName name, Timer timer, long timestamp) {
        Snapshot snapshot = timer.getSnapshot();
        this.addMetric(name, "count", (Object)timer.getCount(), timestamp, MetricObject.MetricType.COUNTER).addMetric(name, "m1", this.convertRate(timer.getOneMinuteRate()), timestamp).addMetric(name, "rt", this.convertDuration(snapshot.getMean()), timestamp).addMetric(name, "mean", this.convertDuration(snapshot.getMean()), timestamp);
        this.addInstantCountMetric(timer.getInstantCount(), name, timer.getInstantCountInterval(), timestamp);
    }

    @Override
    public void collect(MetricName name, Histogram histogram, long timestamp) {
        Snapshot snapshot = histogram.getSnapshot();
        this.addMetric(name, "mean", snapshot.getMean(), timestamp);
    }

    @Override
    public void collect(MetricName name, Compass compass, long timestamp) {
        Snapshot snapshot = compass.getSnapshot();
        this.addMetric(name, "count", (Object)compass.getCount(), timestamp, MetricObject.MetricType.COUNTER).addMetric(name, "m1", this.convertRate(compass.getOneMinuteRate()), timestamp).addMetric(name, "rt", this.convertDuration(snapshot.getMean()), timestamp).addMetric(name, "mean", this.convertDuration(snapshot.getMean()), timestamp);
        this.addInstantCountMetric(compass.getInstantCount(), name, compass.getInstantCountInterval(), timestamp);
        this.addInstantSuccessCount(name, compass, timestamp);
        this.addCompassErrorCode(name, compass, timestamp);
        this.addAddonMetric(name, compass, timestamp);
    }

    @Override
    public void collect(MetricName name, Meter meter, long timestamp) {
        this.addMetric(name, "count", (Object)meter.getCount(), timestamp, MetricObject.MetricType.COUNTER).addMetric(name, "m1", this.convertRate(meter.getOneMinuteRate()), timestamp);
        this.addInstantCountMetric(meter.getInstantCount(), name, meter.getInstantCountInterval(), timestamp);
    }

    @Override
    public void collect(MetricName name, Counter counter, long timestamp) {
        MetricName normalizedName = name.getKey().endsWith("count") ? name : name.resolve("count");
        this.addMetric(normalizedName, counter.getCount(), timestamp, MetricObject.MetricType.COUNTER, this.metricsCollectPeriodConfig.period(name.getMetricLevel()));
        if (counter instanceof BucketCounter) {
            int countInterval = ((BucketCounter)counter).getBucketInterval();
            this.addInstantCountMetric(((BucketCounter)counter).getBucketCounts(), name, countInterval, timestamp);
        }
    }

    @Override
    public void collect(MetricName name, Gauge gauge, long timestamp) {
        this.addMetric(name, gauge.getValue(), timestamp, MetricObject.MetricType.GAUGE, this.metricsCollectPeriodConfig.period(name.getMetricLevel()));
    }
}

