/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.druid;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.DynamicMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularDataSupport;

public class DruidMetricsGaugeSet
extends CachedMetricSet
implements DynamicMetricSet {
    private static final String JDBC_STAT_MANAGER = "com.alibaba.druid.stat.JdbcStatManager";
    private static final String[] DruidMetricsCounters = new String[]{"ExecuteCount", "ErrorCount", "TotalTime", "EffectedRowCount", "FetchRowCount", "InTransactionCount", "ResultSetHoldTime", "ExecuteAndResultSetHoldTime"};
    private static final String[] DruidMetricsGauges = new String[]{"MaxTimespan", "ConcurrentMax", "RunningCount", "EffectedRowCountMax", "FetchRowCountMax"};
    private static final Logger logger = LoggerFactory.getLogger(DruidMetricsGaugeSet.class);
    private static final int DEFAULT_MAX_SQL_SIZE = Integer.getInteger("com.alibaba.csp.ahas.shaded.com.alibaba.metrics.druid.MaxSqlSize", 250);
    private Class<?> jdbcStatManagerClass;
    private Object jdbcStatManager;
    private final int maxSqlSize;
    private Map<String, long[]> sqlData = new HashMap<String, long[]>();
    private Map<String, long[]> deltaSqlData = new HashMap<String, long[]>();
    private MetricName baseName;

    public DruidMetricsGaugeSet(long dataTTL, TimeUnit unit, MetricName baseName) {
        this(dataTTL, unit, Clock.defaultClock(), DEFAULT_MAX_SQL_SIZE, baseName);
    }

    public DruidMetricsGaugeSet(long dataTTL, TimeUnit unit, Clock clock, int maxSqlSize, MetricName baseName) {
        super(dataTTL, unit, clock);
        this.maxSqlSize = maxSqlSize;
        this.baseName = baseName;
        try {
            this.jdbcStatManagerClass = DruidMetricsGaugeSet.class.getClassLoader().loadClass(JDBC_STAT_MANAGER);
            this.jdbcStatManager = this.jdbcStatManagerClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            logger.error("Error during get jdbcStatManager instance: ", e);
        }
    }

    @Override
    protected void getValueInternal() {
        if (this.jdbcStatManagerClass == null || this.jdbcStatManager == null) {
            return;
        }
        try {
            TabularDataSupport tabularData = (TabularDataSupport)this.jdbcStatManagerClass.getMethod("getSqlList", new Class[0]).invoke(this.jdbcStatManager, null);
            for (Object itemValue : tabularData.values()) {
                int i;
                if (!(itemValue instanceof CompositeData)) continue;
                CompositeData compositeData = (CompositeData)itemValue;
                String sql = (String)compositeData.get("SQL");
                if (!this.sqlData.containsKey(sql)) {
                    if (this.sqlData.size() >= this.maxSqlSize) continue;
                    this.sqlData.put(sql, new long[DruidMetricsCounters.length + DruidMetricsGauges.length]);
                    this.deltaSqlData.put(sql, new long[DruidMetricsCounters.length]);
                }
                long[] data = this.sqlData.get(sql);
                long[] deltaData = this.deltaSqlData.get(sql);
                for (i = 0; i < DruidMetricsCounters.length; ++i) {
                    long latest = (Long)compositeData.get(DruidMetricsCounters[i]);
                    deltaData[i] = latest - data[i];
                    data[i] = latest;
                }
                while (i < DruidMetricsCounters.length + DruidMetricsGauges.length) {
                    data[i] = (Long)compositeData.get(DruidMetricsGauges[i - DruidMetricsCounters.length]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error during reading druid stats: ", e);
        }
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Metric> metrics = new HashMap<MetricName, Metric>();
        metrics.put(new MetricName("sql"), this);
        return metrics;
    }

    @Override
    public Map<MetricName, Metric> getDynamicMetrics() {
        this.refreshIfNecessary();
        HashMap<MetricName, Metric> metrics = new HashMap<MetricName, Metric>();
        for (Map.Entry<String, long[]> entry : this.deltaSqlData.entrySet()) {
            int i;
            for (i = 0; i < DruidMetricsCounters.length; ++i) {
                metrics.put(this.baseName.resolve(DruidMetricsCounters[i]).tagged("sql", entry.getKey()), new DruidGauge(this.deltaSqlData, entry.getKey(), i));
            }
            while (i < DruidMetricsCounters.length + DruidMetricsGauges.length) {
                metrics.put(this.baseName.resolve(DruidMetricsGauges[i - DruidMetricsCounters.length]).tagged("sql", entry.getKey()), new DruidGauge(this.sqlData, entry.getKey(), i));
                ++i;
            }
        }
        return metrics;
    }

    private class DruidGauge
    extends PersistentGauge<Long> {
        private Map<String, long[]> dataSource;
        private String sql;
        private int index;

        DruidGauge(Map<String, long[]> dataSource, String sql, int index) {
            this.dataSource = dataSource;
            this.sql = sql;
            this.index = index;
        }

        @Override
        public Long getValue() {
            DruidMetricsGaugeSet.this.refreshIfNecessary();
            return this.dataSource.get(this.sql)[this.index];
        }
    }
}

