/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedGauge;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;

public class CompilationGauge
extends CachedGauge<Long> {
    private final CompilationMXBean mxBean;
    private long lastValue = 0L;

    public CompilationGauge(long timeout, TimeUnit timeoutUnit) {
        super(timeout, timeoutUnit);
        this.mxBean = ManagementFactory.getCompilationMXBean();
    }

    public CompilationGauge(long timeout, TimeUnit timeoutUnit, CompilationMXBean mxBean) {
        super(timeout, timeoutUnit);
        this.mxBean = mxBean;
    }

    @Override
    protected Long loadValue() {
        if (this.mxBean != null && this.mxBean.isCompilationTimeMonitoringSupported()) {
            long delta;
            long currentValue = this.mxBean.getTotalCompilationTime();
            if (this.lastValue > 0L && (delta = currentValue - this.lastValue) > 0L) {
                return delta;
            }
            this.lastValue = currentValue;
        }
        return -10001L;
    }
}

