/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GarbageCollectorMetricSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final List<GarbageCollectorMXBean> garbageCollectors;
    private final List<Long> lastGarbageCountCollectors;
    private final List<Long> lastGarbageTimeCollectors;

    public GarbageCollectorMetricSet() {
        this(ManagementFactory.getGarbageCollectorMXBeans());
    }

    public GarbageCollectorMetricSet(Collection<GarbageCollectorMXBean> garbageCollectors) {
        this.garbageCollectors = new ArrayList<GarbageCollectorMXBean>(garbageCollectors);
        this.lastGarbageCountCollectors = new ArrayList<Long>(){
            {
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        };
        this.lastGarbageTimeCollectors = new ArrayList<Long>(){
            {
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
                this.add(0L);
            }
        };
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, PersistentGauge> gauges = new HashMap<MetricName, PersistentGauge>();
        int index = 0;
        for (final GarbageCollectorMXBean gc : this.garbageCollectors) {
            String name = WHITESPACE.matcher(gc.getName()).replaceAll("_").toLowerCase();
            final int i = index;
            gauges.put(MetricRegistry.name(name, "count"), new PersistentGauge<Long>(){

                @Override
                public Long getValue() {
                    return gc.getCollectionCount();
                }
            });
            gauges.put(MetricRegistry.name(name, "time"), new PersistentGauge<Long>(){

                @Override
                public Long getValue() {
                    return gc.getCollectionTime();
                }
            });
            gauges.put(MetricRegistry.name(name, "count.delta"), new PersistentGauge<Long>(){

                @Override
                public Long getValue() {
                    long current = gc.getCollectionCount();
                    long result = current - (Long)GarbageCollectorMetricSet.this.lastGarbageCountCollectors.get(i);
                    GarbageCollectorMetricSet.this.lastGarbageCountCollectors.set(i, current);
                    return result;
                }
            });
            gauges.put(MetricRegistry.name(name, "time.delta"), new PersistentGauge<Long>(){

                @Override
                public Long getValue() {
                    long current = gc.getCollectionTime();
                    long result = current - (Long)GarbageCollectorMetricSet.this.lastGarbageTimeCollectors.get(i);
                    GarbageCollectorMetricSet.this.lastGarbageTimeCollectors.set(i, current);
                    return result;
                }
            });
            index = i + 1;
        }
        return Collections.unmodifiableMap(gauges);
    }

    @Override
    public long lastUpdateTime() {
        return System.currentTimeMillis();
    }
}

