/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.RatioGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MemoryUsageGaugeSet
implements MetricSet {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;

    public MemoryUsageGaugeSet() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryUsageGaugeSet(MemoryMXBean mxBean, Collection<MemoryPoolMXBean> memoryPools) {
        this.mxBean = mxBean;
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(memoryPools);
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap gauges = new HashMap();
        gauges.put(MetricName.build("total.init"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getInit() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getInit();
            }
        });
        gauges.put(MetricName.build("total.used"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getUsed() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        gauges.put(MetricName.build("total.max"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getMax() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        gauges.put(MetricName.build("total.committed"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getCommitted() + MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put(MetricName.build("heap.init"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getInit();
            }
        });
        gauges.put(MetricName.build("heap.used"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getUsed();
            }
        });
        gauges.put(MetricName.build("heap.max"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getMax();
            }
        });
        gauges.put(MetricName.build("heap.committed"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put(MetricName.build("heap.usage"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax() == -1L ? (double)usage.getCommitted() : (double)usage.getMax());
            }
        });
        gauges.put(MetricName.build("non_heap.init"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getInit();
            }
        });
        gauges.put(MetricName.build("non_heap.used"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        gauges.put(MetricName.build("non_heap.max"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        gauges.put(MetricName.build("non_heap.committed"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        gauges.put(MetricName.build("non_heap.usage"), new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                MemoryUsage usage = MemoryUsageGaugeSet.this.mxBean.getNonHeapMemoryUsage();
                return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax() == -1L ? (double)usage.getCommitted() : (double)usage.getMax());
            }
        });
        for (final MemoryPoolMXBean pool : this.memoryPools) {
            MetricName poolName = MetricRegistry.name("pools", WHITESPACE.matcher(pool.getName()).replaceAll("_").toLowerCase());
            gauges.put(poolName.resolve("usage"), new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    MemoryUsage usage = pool.getUsage();
                    return RatioGauge.Ratio.of(usage.getUsed(), usage.getMax() == -1L ? (double)usage.getCommitted() : (double)usage.getMax());
                }
            });
            gauges.put(poolName.resolve("max"), new PersistentGauge<Long>(){

                @Override
                public Long getValue() {
                    return pool.getUsage().getMax();
                }
            });
            gauges.put(poolName.resolve("used"), new PersistentGauge<Long>(){

                @Override
                public Long getValue() {
                    return pool.getUsage().getUsed();
                }
            });
            gauges.put(poolName.resolve("committed"), new PersistentGauge<Long>(){

                @Override
                public Long getValue() {
                    return pool.getUsage().getCommitted();
                }
            });
            if (pool.getCollectionUsage() != null) {
                gauges.put(poolName.resolve("used_after_gc"), new PersistentGauge<Long>(){

                    @Override
                    public Long getValue() {
                        return pool.getCollectionUsage().getUsed();
                    }
                });
            }
            gauges.put(poolName.resolve("init"), new PersistentGauge<Long>(){

                @Override
                public Long getValue() {
                    return pool.getUsage().getInit();
                }
            });
        }
        return Collections.unmodifiableMap(gauges);
    }

    @Override
    public long lastUpdateTime() {
        return System.currentTimeMillis();
    }
}

