/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ThreadStatesGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(ThreadStatesGaugeSet.class);
    private static final int STACK_TRACE_DEPTH = 0;
    private final ThreadMXBean threads;
    private final Map<MetricName, Metric> gauges;
    private final int[] threadCounts;
    private int liveThreadCount;
    private int daemonThreadCount;
    private int deadlockThreadCount;

    public ThreadStatesGaugeSet() {
        this(ManagementFactory.getThreadMXBean(), DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public ThreadStatesGaugeSet(long dataTTL, TimeUnit unit) {
        this(ManagementFactory.getThreadMXBean(), dataTTL, unit, Clock.defaultClock());
    }

    public ThreadStatesGaugeSet(ThreadMXBean threads, long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.threads = threads;
        this.gauges = new HashMap<MetricName, Metric>();
        this.threadCounts = new int[Thread.State.values().length];
        this.populateGauges();
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.gauges);
    }

    @Override
    protected void getValueInternal() {
        ThreadInfo[] allThreads = this.threads.getThreadInfo(this.threads.getAllThreadIds(), 0);
        if (allThreads == null) {
            logger.warn("java.lang.management.ThreadMXBean.getThreadInfo(long[], int) returns null, might be a JDK bug.");
        } else {
            for (int i = 0; i < this.threadCounts.length; ++i) {
                this.threadCounts[i] = 0;
            }
            for (ThreadInfo info : allThreads) {
                if (info == null) continue;
                int n = info.getThreadState().ordinal();
                this.threadCounts[n] = this.threadCounts[n] + 1;
            }
        }
        this.liveThreadCount = this.threads.getThreadCount();
        this.daemonThreadCount = this.threads.getDaemonThreadCount();
        this.deadlockThreadCount = this.threads.findDeadlockedThreads() == null ? 0 : this.threads.findDeadlockedThreads().length;
    }

    private void populateGauges() {
        for (final Thread.State state : Thread.State.values()) {
            this.gauges.put(MetricRegistry.name(state.toString().toLowerCase(), "count"), new PersistentGauge<Integer>(){

                @Override
                public Integer getValue() {
                    ThreadStatesGaugeSet.this.refreshIfNecessary();
                    return ThreadStatesGaugeSet.this.threadCounts[state.ordinal()];
                }
            });
        }
        this.gauges.put(MetricName.build("count"), new PersistentGauge<Integer>(){

            @Override
            public Integer getValue() {
                ThreadStatesGaugeSet.this.refreshIfNecessary();
                return ThreadStatesGaugeSet.this.liveThreadCount;
            }
        });
        this.gauges.put(MetricName.build("daemon.count"), new PersistentGauge<Integer>(){

            @Override
            public Integer getValue() {
                ThreadStatesGaugeSet.this.refreshIfNecessary();
                return ThreadStatesGaugeSet.this.daemonThreadCount;
            }
        });
        this.gauges.put(MetricName.build("deadlock.count"), new PersistentGauge<Integer>(){

            @Override
            public Integer getValue() {
                ThreadStatesGaugeSet.this.refreshIfNecessary();
                return ThreadStatesGaugeSet.this.deadlockThreadCount;
            }
        });
    }
}

