/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.RatioGauge;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DiskStatGaugeSet
extends CachedMetricSet {
    private Map<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();
    private File[] partitions;
    private long[] partitionTotalSpace;
    private long[] partitionFreeSpace;

    public DiskStatGaugeSet() {
        this(DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock(), new File[]{new File("/")});
    }

    public DiskStatGaugeSet(long dataTTL, TimeUnit unit) {
        this(dataTTL, unit, Clock.defaultClock(), new File[]{new File("/")});
    }

    public DiskStatGaugeSet(long dataTTL, TimeUnit unit, Clock clock, File[] partitions) {
        super(dataTTL, unit, clock);
        if (partitions == null) {
            this.partitions = new File[0];
            this.partitionTotalSpace = new long[0];
            this.partitionFreeSpace = new long[0];
        } else {
            this.partitions = new File[partitions.length];
            for (int i = 0; i < partitions.length; ++i) {
                this.partitions[i] = partitions[i];
            }
            this.partitionTotalSpace = new long[partitions.length];
            this.partitionFreeSpace = new long[partitions.length];
        }
        this.populateGauges();
    }

    @Override
    protected void getValueInternal() {
        for (int i = 0; i < this.partitions.length; ++i) {
            this.partitionTotalSpace[i] = this.partitions[i].getTotalSpace();
            this.partitionFreeSpace[i] = this.partitions[i].getUsableSpace();
        }
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return this.gauges;
    }

    private void populateGauges() {
        for (int i = 0; i < this.partitions.length; ++i) {
            String path = this.partitions[i].getAbsolutePath();
            this.gauges.put(MetricName.build("disk.partition.total").tagged("partition", path), new PartitionTotalGauge(i));
            this.gauges.put(MetricName.build("disk.partition.free").tagged("partition", path), new PartitionFreeGauge(i));
            this.gauges.put(MetricName.build("disk.partition.used_ratio").tagged("partition", path), new PartitionUsageGauge(i));
        }
    }

    private class PartitionUsageGauge
    extends RatioGauge {
        private int index;

        public PartitionUsageGauge(int index) {
            this.index = index;
        }

        @Override
        protected RatioGauge.Ratio getRatio() {
            return RatioGauge.Ratio.of(DiskStatGaugeSet.this.partitionTotalSpace[this.index] - DiskStatGaugeSet.this.partitionFreeSpace[this.index], DiskStatGaugeSet.this.partitionTotalSpace[this.index]);
        }
    }

    private class PartitionFreeGauge
    extends PersistentGauge<Long> {
        private int index;

        public PartitionFreeGauge(int index) {
            this.index = index;
        }

        @Override
        public Long getValue() {
            try {
                DiskStatGaugeSet.this.refreshIfNecessary();
                return DiskStatGaugeSet.this.partitionFreeSpace[this.index];
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }

    private class PartitionTotalGauge
    extends PersistentGauge<Long> {
        private int index;

        public PartitionTotalGauge(int index) {
            this.index = index;
        }

        @Override
        public Long getValue() {
            try {
                DiskStatGaugeSet.this.refreshIfNecessary();
                return DiskStatGaugeSet.this.partitionTotalSpace[this.index];
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }
}

